/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.model.xml.Instructor;
import org.jasig.portlet.courses.model.xml.Location;
import org.jasig.portlet.courses.service.IURLService;
import org.springframework.beans.factory.annotation.Value;

public class UPortalURLServiceImpl
implements IURLService {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Value(value="${portalContext}")
    private String portalContext = "/uPortal";

    public void setPortalContext(String portalContext) {
        this.portalContext = portalContext;
    }

    @Override
    public String getLocationUrl(Location location, PortletRequest request) {
        try {
            String encodedLocation = URLEncoder.encode(location.getIdentifier(), "UTF-8");
            return this.portalContext.concat("/s/location?id=").concat(encodedLocation);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)("Unable to encode location id " + location.getIdentifier()));
            return null;
        }
    }

    @Override
    public String getInstructorUrl(Instructor instructor, PortletRequest request) {
        try {
            String encodedUsername = URLEncoder.encode(instructor.getIdentifier(), "UTF-8");
            return this.portalContext.concat("/s/person?id=").concat(encodedUsername);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)("Unable to encode location id " + instructor.getIdentifier()));
            return null;
        }
    }
}

