<%--

    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.

--%>

<%@ include file="/WEB-INF/jsp/include.jsp"%>

<div class="fl-widget portlet" role="section">

    <div class="fl-widget-titlebar titlebar portlet-titlebar" role="sectionhead">
        <h2 class="title" role="heading">
            <spring:message code="schools"/>
        </h2>
    </div>

    <div class="fl-widget-content content portlet-content" role="main">
        <ul>
            <c:forEach items="${ schools }" var="school">
                <portlet:renderURL var="schoolUrl">
                    <portlet:param name="action" value="departments"/>
                    <portlet:param name="schoolCode" value="${ school.code }"/>
                </portlet:renderURL>
                <li>
                    <a href="${ schoolUrl }">${ school.name }</a>
                </li>
            </c:forEach>
        </ul>
    
    </div>
</div>
