/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.portlet;

import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.courses.dao.ICourseOfferingDao;
import org.jasig.portlet.courses.model.catalog.xml.CourseList;
import org.jasig.portlet.courses.model.catalog.xml.CourseSection;
import org.jasig.portlet.courses.model.catalog.xml.Department;
import org.jasig.portlet.courses.model.catalog.xml.DepartmentList;
import org.jasig.portlet.courses.model.catalog.xml.FullCourseOffering;
import org.jasig.portlet.courses.model.catalog.xml.School;
import org.jasig.portlet.courses.model.catalog.xml.SchoolList;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.Instructor;
import org.jasig.portlet.courses.model.xml.Location;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.mvc.IViewSelector;
import org.jasig.portlet.courses.service.IURLService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class CourseCataloguePortletController {
    private ICourseOfferingDao dao;
    private IURLService urlService;
    private IViewSelector viewSelector;

    @Autowired(required=true)
    public void setCourseOfferingDao(ICourseOfferingDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @RequestMapping
    public String showMainView(ModelMap model, PortletRequest request) {
        SchoolList schoolList = this.dao.getSchools();
        List schools = schoolList.getSchools();
        if (schools.size() == 1) {
            return this.showDepartments(null, ((School)schools.get(0)).getCode(), model, request);
        }
        model.addAttribute("schools", (Object)schools);
        String view = this.viewSelector.isMobile(request) ? "course-catalog/schools-jQM" : "course-catalog/schools";
        return view;
    }

    @RequestMapping(params={"action=departments"})
    public String showDepartments(@RequestParam(required=false) String termCode, @RequestParam String schoolCode, ModelMap model, PortletRequest request) {
        TermList termList = this.dao.getTerms(schoolCode);
        model.addAttribute("terms", (Object)termList.getTerms());
        PortletSession session = request.getPortletSession();
        if (termCode != null) {
            session.setAttribute("currentTerm", (Object)termCode);
        } else {
            String currentTerm = (String)session.getAttribute("currentTerm");
            if (currentTerm != null) {
                termCode = currentTerm;
            } else {
                Term term = this.dao.getCurrentTerm(schoolCode);
                termCode = term.getCode();
                session.setAttribute("currentTerm", (Object)termCode);
            }
        }
        model.addAttribute("term", (Object)termCode);
        DepartmentList departmentList = this.dao.getDepartments(schoolCode, termCode);
        model.addAttribute("departments", (Object)departmentList.getDepartments());
        School school = this.dao.getSchool(schoolCode);
        model.addAttribute("school", (Object)school);
        String view = this.viewSelector.isMobile(request) ? "course-catalog/departments-jQM" : "course-catalog/departments";
        return view;
    }

    @RequestMapping(params={"action=courses"})
    public String showCourses(@RequestParam String termCode, @RequestParam String schoolCode, @RequestParam String departmentCode, ModelMap model, PortletRequest request) {
        TermList termList = this.dao.getTerms(schoolCode);
        model.addAttribute("terms", (Object)termList.getTerms());
        School school = this.dao.getSchool(schoolCode);
        model.addAttribute("school", (Object)school);
        Department department = this.dao.getDepartment(schoolCode, departmentCode, termCode);
        model.addAttribute("department", (Object)department);
        model.addAttribute("termCode", (Object)termCode);
        CourseList courseList = this.dao.getCourseOfferings(schoolCode, departmentCode, termCode);
        model.addAttribute("courses", (Object)courseList.getAbbreviatedCourseOfferings());
        String view = this.viewSelector.isMobile(request) ? "course-catalog/courses-jQM" : "course-catalog/courses";
        return view;
    }

    @RequestMapping(params={"action=course"})
    public String showCourse(@RequestParam String schoolCode, @RequestParam String departmentCode, @RequestParam String courseCode, ModelMap model, PortletRequest request) {
        PortletSession session = request.getPortletSession();
        String termCode = (String)session.getAttribute("currentTerm");
        model.addAttribute("term", (Object)termCode);
        FullCourseOffering course = this.dao.getCourseOffering(courseCode, termCode);
        model.addAttribute("course", (Object)course);
        School school = this.dao.getSchool(schoolCode);
        model.addAttribute("school", (Object)school);
        Department department = this.dao.getDepartment(schoolCode, departmentCode, termCode);
        model.addAttribute("department", (Object)department);
        HashMap<String, String> instructorUrls = new HashMap<String, String>();
        HashMap<String, String> locationUrls = new HashMap<String, String>();
        for (CourseSection section : course.getCourseSections()) {
            for (Instructor instructor : section.getInstructors()) {
                if (instructorUrls.containsKey(instructor.getIdentifier())) continue;
                instructorUrls.put(instructor.getIdentifier(), this.urlService.getInstructorUrl(instructor, request));
            }
            for (CourseMeeting meeting : section.getCourseMeetings()) {
                Location location = meeting.getLocation();
                if (location == null || locationUrls.containsKey(location.getIdentifier())) continue;
                locationUrls.put(location.getIdentifier(), this.urlService.getLocationUrl(location, request));
            }
        }
        model.put((Object)"instructorUrls", instructorUrls);
        model.put((Object)"locationUrls", locationUrls);
        String view = this.viewSelector.isMobile(request) ? "course-catalog/course-jQM" : "course-catalog/course";
        return view;
    }
}

