/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.portlet;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.Instructor;
import org.jasig.portlet.courses.model.xml.Location;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.Course;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.jasig.portlet.courses.mvc.IViewSelector;
import org.jasig.portlet.courses.service.IURLService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class CoursesPortletController {
    public static final String DEFAULT_VIEW_PREFERENCE = "defaultView";
    public static final String COURSE_LIST_VIEW = "courseList";
    public static final String GRADES_LIST_VIEW = "grades";
    public static final String TERMCODE = "termCode";
    public static final String COURSECODE = "courseCode";
    private static final String DISPLAY_COURSE_UPDATES_PREFERENCE = "displayCourseUpdates";
    private static final String DISPLAY_COURSE_BOOKS_PREFERENCE = "displayCourseBooks";
    private ICoursesDao coursesDao;
    private IURLService urlService;
    private IViewSelector viewSelector;

    @Autowired
    public void setCoursesDao(ICoursesDao coursesDao) {
        this.coursesDao = coursesDao;
    }

    @Autowired
    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    @Autowired
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @RequestMapping
    public String defaultView(PortletRequest request, ModelMap model) {
        PortletPreferences preferences = request.getPreferences();
        String defaultView = preferences.getValue(DEFAULT_VIEW_PREFERENCE, COURSE_LIST_VIEW);
        if (GRADES_LIST_VIEW.equals(defaultView)) {
            return this.viewGrades(request, model, null);
        }
        return this.viewCourseList(request, model, null);
    }

    @RequestMapping(params={"action=courseList"})
    public String viewCourseList(PortletRequest request, ModelMap model, @RequestParam(value="termCode", required=false) String termCode) {
        boolean isMobile;
        TermList termList = this.coursesDao.getTermList(request);
        model.put((Object)"termList", (Object)termList);
        termCode = this.getSelectedTermCode(request, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm != null) {
            CoursesByTerm coursesByTerm = this.coursesDao.getCoursesByTerm(request, selectedTerm.getCode());
            model.put((Object)"coursesByTerm", (Object)coursesByTerm);
            model.put((Object)"selectedTerm", (Object)selectedTerm);
        }
        String viewName = (isMobile = this.viewSelector.isMobile(request)) ? "mycourses/courseList-jQM" : "mycourses/courseList";
        return viewName;
    }

    @RequestMapping(params={"action=grades"})
    public String viewGrades(PortletRequest request, ModelMap model, @RequestParam(value="termCode", required=false) String termCode) {
        boolean isMobile;
        TermList termList = this.coursesDao.getTermList(request);
        model.put((Object)"termList", (Object)termList);
        termCode = this.getSelectedTermCode(request, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm != null) {
            CoursesByTerm coursesByTerm = this.coursesDao.getCoursesByTerm(request, selectedTerm.getCode());
            model.put((Object)"coursesByTerm", (Object)coursesByTerm);
            model.put((Object)"selectedTerm", (Object)selectedTerm);
        }
        String viewName = (isMobile = this.viewSelector.isMobile(request)) ? "mycourses/grades-jQM" : "mycourses/grades";
        return viewName;
    }

    @RequestMapping(params={"action=showCourse"})
    public String viewCourse(PortletRequest request, ModelMap model, @RequestParam(value="termCode") String termCode, @RequestParam(value="courseCode") String courseCode) {
        CoursesByTerm summary = this.coursesDao.getCoursesByTerm(request, termCode);
        model.put((Object)"coursesByTerm", (Object)summary);
        Course selectedCourse = summary.getCourse(courseCode);
        HashMap<String, String> instructorUrls = new HashMap<String, String>();
        for (Instructor instructor : selectedCourse.getInstructors()) {
            instructorUrls.put(instructor.getIdentifier(), this.urlService.getInstructorUrl(instructor, request));
        }
        model.put((Object)"instructorUrls", instructorUrls);
        HashMap<String, String> locationUrls = new HashMap<String, String>();
        for (CourseMeeting meeting : selectedCourse.getCourseMeetings()) {
            Location location = meeting.getLocation();
            if (location == null || locationUrls.containsKey(location.getIdentifier())) continue;
            locationUrls.put(location.getIdentifier(), this.urlService.getLocationUrl(location, request));
        }
        model.put((Object)"locationUrls", locationUrls);
        model.put((Object)"course", (Object)selectedCourse);
        boolean isMobile = this.viewSelector.isMobile(request);
        String viewName = isMobile ? "mycourses/courseDetail-jQM" : "mycourses/courseDetail";
        return viewName;
    }

    @ResourceMapping(value="gradesUpdate")
    public String getGradesFragment(ResourceRequest resourceRequest, ModelMap model, @RequestParam(value="termCode") String termCode) {
        TermList termList = this.coursesDao.getTermList((PortletRequest)resourceRequest);
        model.put((Object)"termList", (Object)termList);
        termCode = this.getSelectedTermCode((PortletRequest)resourceRequest, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm == null) {
            throw new IllegalArgumentException("Could not find term for code: " + termCode);
        }
        CoursesByTerm coursesByTerm = this.coursesDao.getCoursesByTerm((PortletRequest)resourceRequest, selectedTerm.getCode());
        model.put((Object)"coursesByTerm", (Object)coursesByTerm);
        model.put((Object)"selectedTerm", (Object)selectedTerm);
        String viewName = "fragments/gradesUpdate";
        return "fragments/gradesUpdate";
    }

    @ActionMapping
    public void copyActionParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        actionResponse.setRenderParameters(actionRequest.getParameterMap());
    }

    @ModelAttribute(value="displayCourseUpdates")
    public Boolean getDisplayCourseUpdates(PortletRequest req) {
        String val = req.getPreferences().getValue(DISPLAY_COURSE_UPDATES_PREFERENCE, Boolean.TRUE.toString());
        return Boolean.valueOf(val);
    }

    @ModelAttribute(value="displayCourseBooks")
    public Boolean getDisplayCourseBooks(PortletRequest req) {
        String val = req.getPreferences().getValue(DISPLAY_COURSE_BOOKS_PREFERENCE, Boolean.TRUE.toString());
        return Boolean.valueOf(val);
    }

    protected String getSelectedTermCode(PortletRequest portletRequest, String requestTermCode) {
        PortletSession portletSession = portletRequest.getPortletSession();
        if (requestTermCode != null) {
            portletSession.setAttribute(TERMCODE, (Object)requestTermCode);
            return requestTermCode;
        }
        return (String)portletSession.getAttribute(TERMCODE);
    }

    protected Term getSelectedTerm(String termCode, TermList termList) {
        if (termCode == null) {
            return termList.getCurrentTerm();
        }
        return termList.getTerm(termCode);
    }
}

