/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.wrapper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jasig.portlet.courses.model.xml.AdditionalInfo;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.CourseSection;
import org.jasig.portlet.courses.model.xml.Location;
import org.jasig.portlet.courses.model.xml.personal.Course;
import org.jasig.portlet.courses.util.DayEnum;
import org.joda.time.DateMidnight;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseSectionWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @JsonIgnore
    private CourseMeeting courseMeeting;
    @JsonIgnore
    private CourseSection courseSection;
    @JsonIgnore
    private Course course;
    private String startTime;
    private String startDateDisplay;
    private String timeRangeDisplay;
    @JsonIgnore
    private DateMidnight startDateObj;
    @JsonIgnore
    public static DateTimeFormatter monthDescrFormat = DateTimeFormat.forPattern((String)"MMM");
    @JsonIgnore
    public static DateTimeFormatter startTimeFormat = DateTimeFormat.forPattern((String)"H:mm");
    @JsonIgnore
    public static DateTimeFormatter amPmFormat = DateTimeFormat.forPattern((String)"h:mm a");
    @JsonIgnore
    public static DateTimeFormatter dateDisplayFormat = DateTimeFormat.forPattern((String)"MMM d");
    private Integer duration;
    private Integer scheduledDay;
    private Integer dayId;
    private String day;
    private String dayDescr;
    private String url;
    private String sessionCode;
    private String sessionStartEndDate;
    private String room;
    private String locationDisplayName;
    private String streetAddress;
    private String courseDescr;
    private String courseTitle;
    private String courseCode;
    private String meetingDescr;
    @JsonIgnore
    private static Map<String, DayEnum> dayMap;
    @JsonIgnore
    private static DayEnum[] dayArr;
    public static Comparator<CourseSectionWrapper> FinalExamComparator;
    public static Comparator<CourseSectionWrapper> ClassScheduleComparator;
    public static Comparator<CourseSectionWrapper> OtherCourseComparator;

    public CourseSectionWrapper() {
    }

    public CourseSectionWrapper(Course course, CourseSection section, String url) {
        this.setUrl(url);
        this.setCourse(course);
        this.setCourseSection(section);
        this.setSessionCode(this.getCourseSectionAdditionalInfoValue(section, "sessionCode"));
        this.setSessionStartEndDate(this.getCourseSectionAdditionalInfoValue(section, "sessionStartEndDate"));
    }

    public CourseSectionWrapper(Course course, CourseSection section, CourseMeeting meeting, String day, String url) {
        this.setDay(dayMap.get(day));
        this.setUrl(url);
        this.setCourse(course);
        this.setCourseSection(section);
        this.setCourseMeeting(meeting);
        this.setSessionCode(this.getCourseSectionAdditionalInfoValue(section, "sessionCode"));
        this.setSessionStartEndDate(this.getCourseSectionAdditionalInfoValue(section, "sessionStartEndDate"));
    }

    public CourseSectionWrapper(Course course, CourseSection section, CourseMeeting meeting, String url) {
        DateMidnight date = meeting.getStartDate();
        this.setStartDateObj(date);
        this.setDay(dayArr[date.getDayOfWeek()]);
        this.setUrl(url);
        this.setCourse(course);
        this.setCourseSection(section);
        this.setCourseMeeting(meeting);
        this.setSessionCode(this.getCourseSectionAdditionalInfoValue(section, "sessionCode"));
        this.setSessionStartEndDate(this.getCourseSectionAdditionalInfoValue(section, "sessionStartEndDate"));
    }

    public CourseMeeting getCourseMeeting() {
        return this.courseMeeting;
    }

    public void setCourseMeeting(CourseMeeting courseMeeting) {
        LocalTime startTime = courseMeeting.getStartTime();
        LocalTime endTime = courseMeeting.getEndTime();
        this.startTime = startTimeFormat.print((ReadablePartial)startTime);
        this.duration = Minutes.minutesBetween((ReadablePartial)startTime, (ReadablePartial)endTime).getMinutes();
        this.timeRangeDisplay = amPmFormat.print((ReadablePartial)startTime) + " to " + amPmFormat.print((ReadablePartial)endTime);
        Location location = courseMeeting.getLocation();
        this.room = location.getRoom();
        this.locationDisplayName = location.getDisplayName();
        this.streetAddress = location.getStreetAddress();
        this.courseMeeting = courseMeeting;
    }

    public CourseSection getCourseSection() {
        return this.courseSection;
    }

    public void setCourseSection(CourseSection courseSection) {
        this.meetingDescr = courseSection.getType() + " " + courseSection.getCode();
        this.courseSection = courseSection;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.courseCode = course.getCode();
        this.courseDescr = course.getCourseDepartment().getName();
        this.courseTitle = course.getTitle();
        this.course = course;
    }

    @JsonIgnore
    public int getExamStartSunday() {
        if (this.getStartDateObj() == null) {
            return 0;
        }
        DateMidnight date = this.getStartDateObj();
        if (date.getDayOfWeek() == 7) {
            return date.getDayOfMonth();
        }
        return date.withDayOfWeek(7).minusWeeks(1).getDayOfMonth();
    }

    @JsonIgnore
    public String getMonthDescrOfStart() {
        if (this.getStartDateObj() == null) {
            return "";
        }
        return monthDescrFormat.print((ReadableInstant)this.getStartDateObj());
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setDay(DayEnum d) {
        this.setDay(d.toString());
        this.setDayId(d.getValue());
        this.setDayDescr(d.getDescr());
    }

    public Integer getDayId() {
        return this.dayId;
    }

    public void setDayId(Integer dayId) {
        this.scheduledDay = this.dayId = dayId.equals(new Integer(7)) ? new Integer(0) : dayId;
    }

    public String getDay() {
        return this.day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public String getDayDescr() {
        return this.dayDescr;
    }

    public void setDayDescr(String dayDescr) {
        this.dayDescr = dayDescr;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMeetingDescr() {
        return this.meetingDescr;
    }

    public String getCourseCode() {
        return this.courseCode;
    }

    public String getCourseDescr() {
        return this.courseDescr;
    }

    public Integer getScheduledDay() {
        return this.scheduledDay;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getCourseTitle() {
        return this.courseTitle;
    }

    public DateMidnight getStartDateObj() {
        return this.startDateObj;
    }

    public void setStartDateObj(DateMidnight startDateObj) {
        this.startDateDisplay = dateDisplayFormat.print((ReadableInstant)startDateObj);
        this.startDateObj = startDateObj;
    }

    public String getRoom() {
        return this.room;
    }

    public String getLocationDisplayName() {
        return this.locationDisplayName;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getStartDateDisplay() {
        return this.startDateDisplay;
    }

    public String getTimeRangeDisplay() {
        return this.timeRangeDisplay;
    }

    public String getSessionCode() {
        return this.sessionCode;
    }

    public void setSessionCode(String sessionCode) {
        this.sessionCode = sessionCode;
    }

    public String getSessionStartEndDate() {
        return this.sessionStartEndDate;
    }

    public void setSessionStartEndDate(String sessionStartEndDate) {
        this.sessionStartEndDate = sessionStartEndDate;
    }

    private String getCourseSectionAdditionalInfoValue(CourseSection courseSection, String key) {
        List additionalInfoList = courseSection.getSectionAdditionalInfos();
        for (AdditionalInfo additionalInfo : additionalInfoList) {
            if (!additionalInfo.getKey().equals(key)) continue;
            return additionalInfo.getValue();
        }
        return "-";
    }

    static {
        dayArr = new DayEnum[]{DayEnum.Su, DayEnum.M, DayEnum.T, DayEnum.W, DayEnum.Th, DayEnum.F, DayEnum.Sa, DayEnum.Su};
        HashMap<String, DayEnum> m = new HashMap<String, DayEnum>();
        m.put(DayEnum.Su.toString(), DayEnum.Su);
        m.put(DayEnum.M.toString(), DayEnum.M);
        m.put(DayEnum.T.toString(), DayEnum.T);
        m.put(DayEnum.W.toString(), DayEnum.W);
        m.put(DayEnum.Th.toString(), DayEnum.Th);
        m.put(DayEnum.F.toString(), DayEnum.F);
        m.put(DayEnum.Sa.toString(), DayEnum.Sa);
        dayMap = Collections.unmodifiableMap(m);
        FinalExamComparator = new Comparator<CourseSectionWrapper>(){

            @Override
            public int compare(CourseSectionWrapper fe1, CourseSectionWrapper fe2) {
                int i = fe1.courseMeeting.getStartDate().compareTo((ReadableInstant)fe2.getCourseMeeting().getStartDate());
                if (i != 0) {
                    return i;
                }
                return fe1.courseMeeting.getStartTime().compareTo((ReadablePartial)fe2.getCourseMeeting().getStartTime());
            }
        };
        ClassScheduleComparator = new Comparator<CourseSectionWrapper>(){

            @Override
            public int compare(CourseSectionWrapper fe1, CourseSectionWrapper fe2) {
                int i = fe1.getDayId().compareTo(fe2.getDayId());
                if (i != 0) {
                    return i;
                }
                return fe1.courseMeeting.getStartTime().compareTo((ReadablePartial)fe2.getCourseMeeting().getStartTime());
            }
        };
        OtherCourseComparator = new Comparator<CourseSectionWrapper>(){

            @Override
            public int compare(CourseSectionWrapper o1, CourseSectionWrapper o2) {
                int courseDescr = o1.getCourseDescr().compareTo(o2.getCourseDescr());
                return courseDescr != 0 ? courseDescr : o1.getCourseSection().getCode().compareTo(o2.getCourseSection().getCode());
            }
        };
    }
}

