/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.handler;

import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.courses.dao.ICoursesSectionDao;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.utils.mvc.IViewSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.handler.SimpleMappingExceptionResolver;

public class MobileAwareExceptionHandler
extends SimpleMappingExceptionResolver
implements ResourceLoaderAware {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IViewSelector viewSelector;
    private String prefix;
    private String suffix;
    private String mobileSuffix;
    private ResourceLoader resourceLoader;
    private ICoursesSectionDao coursesSectionDao;

    @Autowired
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    MobileAwareExceptionHandler(String prefix, String suffix, String mobileSuffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.mobileSuffix = mobileSuffix;
    }

    @Autowired
    @Qualifier(value="coursesSectionDao")
    public void setCoursesSectionDao(ICoursesSectionDao coursesSectionDao) {
        this.coursesSectionDao = coursesSectionDao;
    }

    protected ModelAndView getModelAndView(String view, Exception ex, PortletRequest request) {
        boolean isMobile = this.viewSelector.isMobile(request);
        Resource newView = null;
        if (isMobile) {
            try {
                String mobileViewPath = this.prefix + view + this.mobileSuffix + this.suffix;
                this.logger.debug("Looking for mobile friendly Exception view: " + mobileViewPath);
                newView = this.resourceLoader.getResource(mobileViewPath);
            }
            catch (Exception e) {
                this.logger.debug("No mobile view for: " + view, (Throwable)e);
            }
        }
        ModelAndView mav = newView != null && newView.exists() ? super.getModelAndView(view + this.mobileSuffix, ex, request) : super.getModelAndView(view, ex, request);
        mav.getModelMap().put((Object)"isMobile", (Object)isMobile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Accessing getSelectedTerm from Request/Session");
        }
        Term selectedTerm = this.getSelectedTerm(request);
        mav.getModelMap().put((Object)"selectedTerm", (Object)selectedTerm);
        return mav;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private Term getSelectedTerm(PortletRequest request) {
        String requestTermCode = request.getParameter("termCode");
        PortletSession portletSession = request.getPortletSession(true);
        Term selectedTerm = new Term();
        if (portletSession != null && !StringUtils.isEmpty((Object)portletSession.getAttribute("termCode"))) {
            String sessionTermCode = (String)portletSession.getAttribute("termCode");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Term Code found in PortletSession......" + sessionTermCode);
            }
            selectedTerm.setCode(sessionTermCode);
        } else if (!StringUtils.isEmpty((Object)requestTermCode)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Term Code found in Request......" + requestTermCode);
            }
            selectedTerm.setCode(requestTermCode);
            portletSession.setAttribute("termCode", (Object)requestTermCode);
        } else {
            try {
                TermList termList = this.coursesSectionDao.getTermList(request);
                selectedTerm = termList.getCurrentTerm();
                portletSession.setAttribute("termCode", (Object)selectedTerm.getCode());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Term Code found in ICoursesSectionDao....." + selectedTerm.getCode());
                }
            }
            catch (Exception ex) {
                this.logger.error("Error Occurred while accessing TermCode from ICoursesSectionDao", (Throwable)ex);
            }
        }
        return selectedTerm;
    }
}

