/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.CourseSection;
import org.jasig.portlet.courses.mvc.wrapper.LocationWrapper;
import org.jasig.portlet.courses.service.IURLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseSectionMeetingWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String[] meetingTypesWithNoLocation = new String[]{"TBD", "PENDING", "ONLINE", "OFF CAMPUS"};
    private static final String ENROLLEDCLASSESGRADESFNAME_PREF = "enrolledClassesFname";
    private static final String ENROLLEDCLASSESWINDOWSTATE_PREF = "enrolledClassesWindowState";
    private static final String ENROLLEDCLASSESFIXEDPARAM_PREF = "enrolledClassesWindowFixedParameterString";
    private static final String ENROLLEDCLASSESNATIVEMAPBASESURL_PREF = "enrolledClassesNativeMapBaseURL";
    private static final String ENROLLEDCLASSESNATIVEMAPZOOMINDEX_PREF = "enrolledClassesNativeMapZIndex";
    private CourseSection courseSection;
    private PortletPreferences portletPreferences;
    private boolean mobile;
    private String termCode;
    private IURLService urlService;
    private Map<LocationWrapper, List<CourseMeeting>> locationClassMeetingMap;
    private Map<LocationWrapper, List<CourseMeeting>> locationExamMeetingMap;

    public String getTermCode() {
        return this.termCode;
    }

    public void setTermCode(String termCode) {
        this.termCode = termCode;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    public PortletPreferences getPortletPreferences() {
        return this.portletPreferences;
    }

    public void setPortletPreferences(PortletPreferences portletPreferences) {
        this.portletPreferences = portletPreferences;
    }

    public IURLService getUrlService() {
        return this.urlService;
    }

    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    public Map<LocationWrapper, List<CourseMeeting>> getLocationExamMeetingMap() {
        return this.locationExamMeetingMap;
    }

    public void setLocationExamMeetingMap(Map<LocationWrapper, List<CourseMeeting>> locationExamMeetingMap) {
        this.locationExamMeetingMap = locationExamMeetingMap;
    }

    public void setLocationClassMeetingMap(Map<LocationWrapper, List<CourseMeeting>> locationClassMeetingMap) {
        this.locationClassMeetingMap = locationClassMeetingMap;
    }

    public CourseSection getCourseSection() {
        return this.courseSection;
    }

    public void setCourseSection(CourseSection courseSection) {
        this.courseSection = courseSection;
    }

    public Map getLocationClassMeetingMap() {
        return this.locationClassMeetingMap;
    }

    public CourseSectionMeetingWrapper() {
    }

    public CourseSectionMeetingWrapper(CourseSection courseSection, PortletPreferences portletPreferences, boolean mobile, String termCode, IURLService urlService) {
        this.setUrlService(urlService);
        this.setCourseSection(courseSection);
        this.setPortletPreferences(portletPreferences);
        this.setMobile(mobile);
        this.setTermCode(termCode);
        this.setLocationClassMeetingMap(this.setClassMeetingMap(courseSection));
        this.setLocationExamMeetingMap(this.setExamMeetingMap(courseSection));
    }

    private Map<LocationWrapper, List<CourseMeeting>> setClassMeetingMap(CourseSection courseSection) {
        String displayName = "";
        String roomNo = "";
        String streetAddress = "";
        ArrayList<CourseMeeting> courseMeetings = null;
        this.logger.debug("Setting ClassMeeting Map......");
        HashMap<LocationWrapper, List<CourseMeeting>> locationMeetMap = new HashMap<LocationWrapper, List<CourseMeeting>>();
        for (CourseMeeting courseMeetingObj : courseSection.getCourseMeetings()) {
            this.logger.debug("CourseMeeting Type........" + courseMeetingObj.getType());
            if (!courseMeetingObj.getType().toUpperCase().equals("CLASS")) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("courseMeetingObj.getLocation().getDisplayName()........" + courseMeetingObj.getLocation().getDisplayName());
                this.logger.debug("courseMeetingObj.getLocation().getStreetAddress()........" + courseMeetingObj.getLocation().getStreetAddress());
                this.logger.debug("courseMeetingObj.getLocation().getRoom()........" + courseMeetingObj.getLocation().getRoom());
                this.logger.debug("courseMeetingObj.getLocation().getIdentifier()........" + courseMeetingObj.getLocation().getIdentifier());
                this.logger.debug("courseMeetingObj.getLocation().getLatitude()........" + courseMeetingObj.getLocation().getLatitude());
                this.logger.debug("courseMeetingObj.getLocation().getLongitude()........" + courseMeetingObj.getLocation().getLongitude());
                this.logger.debug("TermCode........" + this.getTermCode());
                this.logger.debug("isMobile........" + this.isMobile());
            }
            if (!(courseMeetingObj.getLocation().getDisplayName().equals(displayName) && courseMeetingObj.getLocation().getStreetAddress().equals(streetAddress) && courseMeetingObj.getLocation().getRoom().equals(roomNo))) {
                this.logger.debug("Class Location Not Matching......");
                LocationWrapper locationWrapper = null;
                if (StringUtils.indexOfAny((String)courseMeetingObj.getLocation().getDisplayName(), (String[])meetingTypesWithNoLocation) == 0) {
                    this.logger.debug("Location DisplayName is " + courseMeetingObj.getLocation().getDisplayName());
                    locationWrapper = new LocationWrapper(courseMeetingObj.getLocation().getDisplayName(), "", "", 0.0, 0.0, "", "");
                } else {
                    String locationUrl = "";
                    if (!this.isMobile()) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("pP_term", this.getTermCode());
                        params.put("pP_buildingName", courseMeetingObj.getLocation().getDisplayName());
                        locationUrl = this.getUrlService().getOtherPortletURL(this.getPortletPreferences(), ENROLLEDCLASSESGRADESFNAME_PREF, ENROLLEDCLASSESWINDOWSTATE_PREF, ENROLLEDCLASSESFIXEDPARAM_PREF, params);
                    } else {
                        locationUrl = this.getUrlService().getNativeMapUrl(this.getPortletPreferences(), ENROLLEDCLASSESNATIVEMAPBASESURL_PREF, courseMeetingObj.getLocation().getRoom(), courseMeetingObj.getLocation().getDisplayName(), courseMeetingObj.getLocation().getStreetAddress(), new Double(courseMeetingObj.getLocation().getLongitude()).toString(), new Double(courseMeetingObj.getLocation().getLatitude()).toString(), ENROLLEDCLASSESNATIVEMAPZOOMINDEX_PREF);
                    }
                    this.logger.debug("Location URL.....in CLASS" + locationUrl);
                    locationWrapper = new LocationWrapper(courseMeetingObj.getLocation().getDisplayName(), courseMeetingObj.getLocation().getIdentifier(), courseMeetingObj.getLocation().getStreetAddress(), courseMeetingObj.getLocation().getLatitude(), courseMeetingObj.getLocation().getLongitude(), courseMeetingObj.getLocation().getRoom(), locationUrl);
                }
                courseMeetings = new ArrayList<CourseMeeting>();
                locationMeetMap.put(locationWrapper, courseMeetings);
                displayName = courseMeetingObj.getLocation().getDisplayName();
                streetAddress = courseMeetingObj.getLocation().getStreetAddress();
                roomNo = courseMeetingObj.getLocation().getRoom();
                courseMeetings.add(courseMeetingObj);
                this.logger.debug("Class Location Not Matching......Done");
                continue;
            }
            this.logger.debug("Class Location Matching......");
            courseMeetings.add(courseMeetingObj);
        }
        if (locationMeetMap.isEmpty()) {
            this.logger.debug("CLASS MAP IS EMPTY !!!!!");
        }
        return locationMeetMap;
    }

    private Map<LocationWrapper, List<CourseMeeting>> setExamMeetingMap(CourseSection courseSection) {
        String displayName = null;
        String roomNo = null;
        String streetAddress = null;
        ArrayList<CourseMeeting> courseMeetings = null;
        courseMeetings = new ArrayList<CourseMeeting>();
        this.logger.debug("Setting ExamMeeting Map......");
        HashMap<LocationWrapper, List<CourseMeeting>> locationMeetMap = new HashMap<LocationWrapper, List<CourseMeeting>>();
        for (CourseMeeting courseMeetingObj : courseSection.getCourseMeetings()) {
            this.logger.debug("CourseMeeting Type........" + courseMeetingObj.getType());
            if (!courseMeetingObj.getType().toUpperCase().equals("EXAM")) continue;
            this.logger.debug("courseMeetingObj.getLocation().getDisplayName()........" + courseMeetingObj.getLocation().getDisplayName());
            this.logger.debug("courseMeetingObj.getLocation().getStreetAddress()........" + courseMeetingObj.getLocation().getStreetAddress());
            this.logger.debug("courseMeetingObj.getLocation().getRoom()........" + courseMeetingObj.getLocation().getRoom());
            this.logger.debug("courseMeetingObj.getLocation().getIdentifier()........" + courseMeetingObj.getLocation().getIdentifier());
            this.logger.debug("courseMeetingObj.getLocation().getLatitude()........" + courseMeetingObj.getLocation().getLatitude());
            this.logger.debug("courseMeetingObj.getLocation().getLongitude()........" + courseMeetingObj.getLocation().getLongitude());
            this.logger.debug("isMobile........" + this.isMobile());
            if (!(courseMeetingObj.getLocation() == null || courseMeetingObj.getLocation().getStreetAddress() == null || courseMeetingObj.getLocation().getRoom() == null || courseMeetingObj.getLocation().getDisplayName().equals(displayName) || courseMeetingObj.getLocation().getStreetAddress().equals(streetAddress) || courseMeetingObj.getLocation().getRoom().equals(roomNo))) {
                this.logger.debug("Exam Location Not Matching......");
                LocationWrapper locationWrapper = null;
                if (StringUtils.indexOfAny((String)courseMeetingObj.getLocation().getDisplayName(), (String[])meetingTypesWithNoLocation) == 0) {
                    this.logger.debug("Location DisplayName is " + courseMeetingObj.getLocation().getDisplayName());
                    locationWrapper = new LocationWrapper(courseMeetingObj.getLocation().getDisplayName(), "", "", 0.0, 0.0, "", "");
                } else {
                    String locationUrl = "";
                    locationUrl = this.getUrlService().getNativeMapUrl(this.getPortletPreferences(), ENROLLEDCLASSESNATIVEMAPBASESURL_PREF, courseMeetingObj.getLocation().getRoom(), courseMeetingObj.getLocation().getDisplayName(), courseMeetingObj.getLocation().getStreetAddress(), new Double(courseMeetingObj.getLocation().getLongitude()).toString(), new Double(courseMeetingObj.getLocation().getLatitude()).toString(), ENROLLEDCLASSESNATIVEMAPZOOMINDEX_PREF);
                    this.logger.debug("Location URL.....in EXAM" + locationUrl);
                    locationWrapper = new LocationWrapper(courseMeetingObj.getLocation().getDisplayName(), courseMeetingObj.getLocation().getIdentifier(), courseMeetingObj.getLocation().getStreetAddress(), courseMeetingObj.getLocation().getLatitude(), courseMeetingObj.getLocation().getLongitude(), courseMeetingObj.getLocation().getRoom(), locationUrl);
                }
                courseMeetings = new ArrayList();
                locationMeetMap.put(locationWrapper, courseMeetings);
                displayName = courseMeetingObj.getLocation().getDisplayName();
                streetAddress = courseMeetingObj.getLocation().getStreetAddress();
                roomNo = courseMeetingObj.getLocation().getRoom();
                this.logger.debug("Exam Location Not Matching......Done");
                courseMeetings.add(courseMeetingObj);
                continue;
            }
            this.logger.debug("Exam Location Matching......");
            courseMeetings.add(courseMeetingObj);
        }
        if (locationMeetMap.isEmpty()) {
            this.logger.debug("EXAM MAP IS EMPTY !!!!!");
        }
        return locationMeetMap;
    }

    public void printCourseSectionWrapperList(List<CourseSectionMeetingWrapper> courseSectionMeetingWrapperList) {
        for (CourseSectionMeetingWrapper courseSectionMeetingWrapper : courseSectionMeetingWrapperList) {
            List<CourseMeeting> courseMeetings;
            this.logger.debug("COURSE SECTION>>>>>>>>>>>>>>>");
            this.logger.debug(courseSectionMeetingWrapper.getCourseSection().getType() + " " + courseSectionMeetingWrapper.getCourseSection().getCode());
            Map classMeetingMap = courseSectionMeetingWrapper.getLocationClassMeetingMap();
            Map<LocationWrapper, List<CourseMeeting>> examMeetingMap = courseSectionMeetingWrapper.getLocationExamMeetingMap();
            Set<Object> locationWrapperSet = classMeetingMap.keySet();
            this.logger.debug("DUMPING ALL CLASSES>>>>>>>>>>>>>>>");
            for (LocationWrapper locationWrapper : locationWrapperSet) {
                courseMeetings = (List<CourseMeeting>)classMeetingMap.get(locationWrapper);
                for (CourseMeeting courseMeeting : courseMeetings) {
                    this.logger.debug(courseMeeting.getType());
                    this.logger.debug(courseMeeting.getFormattedMeetingTime() + "......" + courseMeeting.getDayIds());
                }
                this.logger.debug(locationWrapper.getDisplayName() + "....." + locationWrapper.getRoom() + "....." + locationWrapper.getStreetAddress());
            }
            this.logger.debug("DUMPING ALL EXAMS>>>>>>>>>>>>>>>");
            locationWrapperSet = examMeetingMap.keySet();
            for (LocationWrapper locationWrapper : locationWrapperSet) {
                courseMeetings = examMeetingMap.get(locationWrapper);
                for (CourseMeeting courseMeeting : courseMeetings) {
                    this.logger.debug(courseMeeting.getType());
                    this.logger.debug(courseMeeting.getFormattedMeetingTime() + "......" + courseMeeting.getDayIds());
                }
                this.logger.debug(locationWrapper.getDisplayName() + "....." + locationWrapper.getRoom() + "....." + locationWrapper.getStreetAddress());
            }
        }
    }
}

