/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.degreeprogress.mvc.portlet;

import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.degreeprogress.dao.IDegreeProgramDao;
import org.jasig.portlet.degreeprogress.dao.IDegreeProgressDao;
import org.jasig.portlet.degreeprogress.dao.WhatIfRequest;
import org.jasig.portlet.degreeprogress.model.DegreeProgramSummary;
import org.jasig.portlet.degreeprogress.model.ProgramComponent;
import org.jasig.portlet.degreeprogress.model.xml.DegreeProgressReport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class DegreeProgressController {
    public static final String PREFERENCE_INFORMATION_LINK = "DegreeProgress.INFORMATION_LINK";
    public static final String PREFERENCE_INFORMATION_LINK_DEFAULT = "#;";
    private IDegreeProgressDao degreeProgressDao;
    private IDegreeProgramDao degreeProgramDao;
    private ICoursesDao coursesDao;

    @Autowired(required=true)
    public void setDegreeProgressDao(IDegreeProgressDao degreeProgressDao) {
        this.degreeProgressDao = degreeProgressDao;
    }

    @Autowired(required=true)
    public void setDegreeProgramDao(IDegreeProgramDao degreeProgramDao) {
        this.degreeProgramDao = degreeProgramDao;
    }

    @Autowired(required=true)
    @Qualifier(value="finalGradesServiceDao")
    public void setCoursesDao(ICoursesDao coursesDao) {
        this.coursesDao = coursesDao;
    }

    @RequestMapping
    public ModelAndView getMainView(PortletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletPreferences preferences = request.getPreferences();
        model.put("terms", this.degreeProgramDao.getEntryTerms());
        model.put("infoLink", preferences.getValue(PREFERENCE_INFORMATION_LINK, PREFERENCE_INFORMATION_LINK_DEFAULT));
        return new ModelAndView("selectReport", model);
    }

    @RequestMapping(params={"action=getScenario"})
    public String showDegreeProgressForm(Model model, PortletRequest request) {
        try {
            String currentTerm = this.coursesDao.getTermList(request).getCurrentTerm().getCode();
            if (!model.containsAttribute("whatIfForm")) {
                WhatIfRequest whatIfRequest = this.degreeProgressDao.createWhatIfRequest(request);
                whatIfRequest.setCampus("1");
                whatIfRequest.setCurrentTerm(currentTerm);
                model.addAttribute("whatIfForm", (Object)whatIfRequest);
            }
            model.addAttribute("campuses", (Object)this.degreeProgramDao.getCampuses());
            model.addAttribute("colleges", (Object)this.degreeProgramDao.getColleges());
            model.addAttribute("concentrations", (Object)this.degreeProgramDao.getConcentrations());
            model.addAttribute("degrees", (Object)this.degreeProgramDao.getDegrees());
            model.addAttribute("departments", (Object)this.degreeProgramDao.getDepartments());
            model.addAttribute("entryTerms", (Object)this.degreeProgramDao.getEntryTerms());
            model.addAttribute("evaluationTerms", (Object)this.degreeProgramDao.getEvaluationTerms());
            model.addAttribute("levels", (Object)this.degreeProgramDao.getLevels());
            model.addAttribute("minors", (Object)this.degreeProgramDao.getMinors());
            model.addAttribute("programs", (Object)this.degreeProgramDao.getPrograms(currentTerm));
            return "whatIf";
        }
        catch (Exception e) {
            System.out.println(e);
            return "error";
        }
    }

    @RequestMapping(params={"action=showWhatIf"})
    public ModelAndView showWhatIfProgress(PortletRequest request, @ModelAttribute(value="whatIfForm") WhatIfRequest whatIfRequest) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            DegreeProgressReport report = this.degreeProgressDao.getWhatIfReport(whatIfRequest);
            model.put("report", report);
            DegreeProgramSummary summary = new DegreeProgramSummary();
            List programs = this.degreeProgramDao.getPrograms(whatIfRequest.getEntryTerm());
            for (Object program : programs) {
                if (!program.getKey().equals(whatIfRequest.getProgram())) continue;
                summary.setProgram(program.getName());
                break;
            }
            List majors = this.degreeProgramDao.getMajors(whatIfRequest.getProgram());
            for (Object major : majors) {
                if (!major.getKey().equals(whatIfRequest.getMajor())) continue;
                summary.getMajors().add(major);
                break;
            }
            if (StringUtils.isNotBlank((String)whatIfRequest.getMajor2())) {
                for (Object major : majors) {
                    if (!major.getKey().equals(whatIfRequest.getMajor2())) continue;
                    summary.getMajors().add(major);
                    break;
                }
            }
            List minors = this.degreeProgramDao.getMinors();
            if (StringUtils.isNotBlank((String)whatIfRequest.getMinor())) {
                for (ProgramComponent minor : minors) {
                    if (!minor.getKey().equals(whatIfRequest.getMinor())) continue;
                    summary.getMinors().add(minor);
                    break;
                }
            }
            if (StringUtils.isNotBlank((String)whatIfRequest.getMinor2())) {
                for (ProgramComponent minor : minors) {
                    if (!minor.getKey().equals(whatIfRequest.getMinor2())) continue;
                    summary.getMinors().add(minor);
                    break;
                }
            }
            List concentrations = this.degreeProgramDao.getConcentrations();
            if (StringUtils.isNotBlank((String)whatIfRequest.getConcentration())) {
                for (ProgramComponent concentration : concentrations) {
                    if (!concentration.getKey().equals(whatIfRequest.getConcentration())) continue;
                    summary.getConcentrations().add(concentration);
                    break;
                }
            }
            if (StringUtils.isNotBlank((String)whatIfRequest.getConcentration2())) {
                for (ProgramComponent concentration : concentrations) {
                    if (!concentration.getKey().equals(whatIfRequest.getConcentration2())) continue;
                    summary.getConcentrations().add(concentration);
                    break;
                }
            }
            model.put("program", summary);
            return new ModelAndView("degreeProgress", model);
        }
        catch (EmptyResultDataAccessException e) {
            System.out.print((Object)e);
            String err = "Your Banner record is not complete at this time please try again later.";
            model.put("err", err);
            return new ModelAndView("error", model);
        }
        catch (UncategorizedSQLException e) {
            System.out.print((Object)e);
            String err = "You are not a student and cannot run this portlet.";
            model.put("err", err);
            return new ModelAndView("error", model);
        }
        catch (Exception e) {
            System.out.print(e);
            e.printStackTrace();
            String err = "General Error\nPlease check the log.";
            model.put("err", err);
            return new ModelAndView("error", model);
        }
    }

    @RequestMapping(params={"action=showProgress"})
    public ModelAndView showDegreeProgress(PortletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            DegreeProgressReport report = this.degreeProgressDao.getProgressReport(request);
            model.put("report", report);
            DegreeProgramSummary summary = this.degreeProgramDao.getProgramSummary(request);
            model.put("program", summary);
            return new ModelAndView("degreeProgress", model);
        }
        catch (EmptyResultDataAccessException e) {
            System.out.print((Object)e);
            String err = "Your Banner record is not complete at this time please try again later.";
            model.put("err", err);
            return new ModelAndView("error", model);
        }
        catch (UncategorizedSQLException e) {
            System.out.print((Object)e);
            String err = "You are not a student and cannot run this portlet.";
            model.put("err", err);
            return new ModelAndView("error", model);
        }
        catch (Exception e) {
            System.out.print(e);
            String err = "General Error\nPlease check the log.";
            model.put("err", err);
            return new ModelAndView("error", model);
        }
    }
}

