/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.portlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import org.jasig.portlet.courses.dao.ICoursesSectionDao;
import org.jasig.portlet.courses.model.xml.AdditionalInfo;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.CourseSection;
import org.jasig.portlet.courses.model.xml.Instructor;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.Course;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.jasig.portlet.courses.mvc.wrapper.CourseSectionMeetingWrapper;
import org.jasig.portlet.courses.mvc.wrapper.CourseSectionWrapper;
import org.jasig.portlet.courses.service.IURLService;
import org.jasig.portlet.utils.mvc.IViewSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class UWCoursesPortletController {
    public static final String DEFAULT_VIEW_PREFERENCE = "defaultView";
    public static final String COURSE_LIST_VIEW = "courseList";
    public static final String CLASS_SCHEDULE_VIEW = "classSchedule";
    public static final String GRADES_LIST_VIEW = "grades";
    public static final String TERMCODE = "termCode";
    public static final String VIEW = "view";
    public static final String PRINTVIEW = "printView";
    public static final String COURSECODE = "courseCode";
    public static final String CATALOGNBR = "catalogNbr";
    public static final String SUBJECTCODE = "subjectCode";
    public static final String CLASSNBR = "classNbr";
    public static final String COURSEID = "courseId";
    public static final String STANDALONE_SCHEDULE_PREFERENCE = "standaloneSchedule";
    private static final String DISPLAY_COURSE_UPDATES_PREFERENCE = "displayCourseUpdates";
    private static final String DISPLAY_COURSE_BOOKS_PREFERENCE = "displayCourseBooks";
    public static final String FINALGRADESFNAME_PREF = "finalGradesFname";
    public static final String FINALGRADESWINDOWSTATE_PREF = "finalGradesWindowState";
    public static final String FINALGRADESFIXEDPARAM_PREF = "finalGradesWindowFixedParameterString";
    private ICoursesSectionDao coursesSectionDao;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IURLService urlService;
    private IViewSelector viewSelector;

    @Autowired
    @Qualifier(value="coursesSectionDao")
    public void setCoursesSectionDao(ICoursesSectionDao coursesSectionDao) {
        this.coursesSectionDao = coursesSectionDao;
    }

    @Autowired
    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    @Autowired
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @RequestMapping
    public String defaultView(PortletRequest request, MimeResponse mimeResponse, ModelMap model) {
        PortletPreferences preferences = request.getPreferences();
        String defaultView = preferences.getValue(DEFAULT_VIEW_PREFERENCE, COURSE_LIST_VIEW);
        this.logger.info("Calling defaultView.....");
        if (CLASS_SCHEDULE_VIEW.equals(defaultView)) {
            request.getPortletSession().setAttribute("helpDeskURL", (Object)preferences.getValue("helpDeskURL", "https://kb.wisc.edu/helpdesk/page.php?id=35501"));
            return this.viewClassSchedule(request, mimeResponse, model, null, "grid", Boolean.valueOf(false));
        }
        request.getPortletSession().setAttribute("helpDeskURL", (Object)preferences.getValue("helpDeskURL", "https://kb.wisc.edu/helpdesk/page.php?id=35501"));
        return this.viewCourseList(request, model, null);
    }

    @RequestMapping(params={"action=courseList"})
    public String viewCourseList(PortletRequest request, ModelMap model, @RequestParam(value="termCode", required=false) String termCode) {
        TermList termList = this.coursesSectionDao.getTermList(request);
        model.put((Object)"termList", (Object)termList);
        termCode = this.getSelectedTermCode(request, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm != null) {
            CoursesByTerm coursesByTerm = this.coursesSectionDao.getCoursesByTerm(request, selectedTerm.getCode(), termList);
            model.put((Object)"coursesByTerm", (Object)coursesByTerm);
            model.put((Object)"selectedTerm", (Object)selectedTerm);
        }
        boolean isMobile = this.viewSelector.isMobile(request);
        model.put((Object)"isMobile", (Object)isMobile);
        String viewName = isMobile ? "myuwcourses/courseList-jQM" : "myuwcourses/courseList";
        return viewName;
    }

    @RequestMapping(params={"action=showCourse"})
    public String viewCourse(PortletRequest request, ModelMap model, @RequestParam(value="termCode") String termCode, @RequestParam(value="catalogNbr") String catalogNbr, @RequestParam(value="subjectCode") String subjectCode, @RequestParam(value="classNbr") String classNbr, @RequestParam(value="courseId") String courseId) {
        boolean isMobile = this.viewSelector.isMobile(request);
        PortletPreferences prefs = request.getPreferences();
        TermList termList = this.coursesSectionDao.getTermList(request);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        model.put((Object)"selectedTerm", (Object)selectedTerm);
        CoursesByTerm summary = this.coursesSectionDao.getCoursesByTerm(request, termCode, termList);
        model.put((Object)"coursesByTerm", (Object)summary);
        this.logger.debug("selectedCourse code is ....." + catalogNbr + subjectCode);
        Course course = this.coursesSectionDao.getCoursesBySection(request, termCode, catalogNbr, subjectCode, courseId, classNbr, termList);
        HashMap<String, String> instructorUrls = new HashMap<String, String>();
        for (CourseSection courseSection : course.getCourseSections()) {
            for (Instructor instructor : courseSection.getInstructors()) {
                this.logger.debug("instructor.getIdentifier()........" + instructor.getIdentifier());
                this.logger.debug("instructor.getFullName()......." + instructor.getFullName());
                this.logger.debug("instructor.getAbbreviation()........." + instructor.getAbbreviation());
                this.logger.debug("instructor.getInstructorAdditionalInfos()........." + instructor.getInstructorAdditionalInfos());
                instructorUrls.put(instructor.getIdentifier(), this.urlService.getInstructorUrl(instructor, request));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("instructorUrls......." + instructorUrls);
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pP_termCode", termCode);
        String fgBaseUrl = this.urlService.getOtherPortletURL(prefs, FINALGRADESFNAME_PREF, FINALGRADESWINDOWSTATE_PREF, FINALGRADESFIXEDPARAM_PREF, params);
        model.put((Object)"finalGradeUrl", (Object)fgBaseUrl);
        model.put((Object)"instructorUrls", instructorUrls);
        model.put((Object)"courseSectionMeetingList", (Object)this.getCourseMeetingsWrapperList(course, prefs, isMobile, termCode));
        model.put((Object)"course", (Object)course);
        String viewName = isMobile ? "myuwcourses/courseDetail-jQM" : "myuwcourses/courseDetail";
        return viewName;
    }

    @RequestMapping(params={"action=showExams"})
    public String viewExam(PortletRequest request, MimeResponse response, ModelMap model, @RequestParam(value="termCode") String termCode, @RequestParam(value="view") String view, @RequestParam(value="printView", required=false, defaultValue="false") Boolean printView) {
        TermList termList = this.coursesSectionDao.getTermList(request);
        model.put((Object)"termList", (Object)termList);
        model.put((Object)PRINTVIEW, (Object)printView);
        model.put((Object)"isStandaloneSchedule", (Object)Boolean.parseBoolean(request.getPreferences().getValue(STANDALONE_SCHEDULE_PREFERENCE, "false")));
        termCode = this.getSelectedTermCode(request, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm != null) {
            CoursesByTerm coursesByTerm = this.coursesSectionDao.getCoursesByTerm(request, selectedTerm.getCode(), termList);
            model.put((Object)"coursesByTerm", (Object)coursesByTerm);
            model.put((Object)"selectedTerm", (Object)selectedTerm);
        }
        this.logger.debug("Calling getFinalExams....." + termCode);
        List courseList = this.coursesSectionDao.getFinalExams(request, termCode, termList);
        ArrayList<CourseSectionWrapper> finalExamsList = new ArrayList<CourseSectionWrapper>();
        for (Course course : courseList) {
            for (CourseSection courseSection : course.getCourseSections()) {
                PortletURL url = this.createCourseDetailUrl(course, courseSection, response, termCode);
                for (CourseMeeting courseMeeting : courseSection.getCourseMeetings()) {
                    CourseSectionWrapper finalExam = new CourseSectionWrapper(course, courseSection, courseMeeting, url.toString());
                    finalExamsList.add(finalExam);
                }
            }
        }
        Collections.sort(finalExamsList, CourseSectionWrapper.FinalExamComparator);
        model.put((Object)"finalExamsList", finalExamsList);
        if (finalExamsList.isEmpty()) {
            model.put((Object)"startDateSunday", (Object)false);
        } else {
            model.put((Object)"startMonthDescr", (Object)((CourseSectionWrapper)finalExamsList.get(0)).getMonthDescrOfStart());
            model.put((Object)"startDateSunday", (Object)((CourseSectionWrapper)finalExamsList.get(0)).getExamStartSunday());
        }
        boolean isMobile = this.viewSelector.isMobile(request);
        String viewName = "";
        if (view.equals("list")) {
            viewName = isMobile ? "myuwcourses/examList-jQM" : "myuwcourses/examList";
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                model.put((Object)"finalExamsListJson", (Object)mapper.writeValueAsString((Object)((List)model.get((Object)"finalExamsList"))));
            }
            catch (IOException e) {
                String msg = "Failed to return jsonClassSchedule response";
                this.logger.error(msg, (Throwable)e);
                throw new RuntimeException(msg);
            }
            viewName = isMobile ? "myuwcourses/examGrid-jQM" : "myuwcourses/examGrid";
        }
        return viewName;
    }

    private void getClassScheduleList(PortletRequest request, MimeResponse response, ModelMap model, String termCode) {
        TermList termList = this.coursesSectionDao.getTermList(request);
        model.put((Object)"termList", (Object)termList);
        termCode = this.getSelectedTermCode(request, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm == null) {
            return;
        }
        this.logger.info("FOUND SELECTED TERM !!!!" + selectedTerm.getCode());
        CoursesByTerm coursesByTerm = this.coursesSectionDao.getCoursesByTerm(request, selectedTerm.getCode(), termList);
        model.put((Object)"coursesByTerm", (Object)coursesByTerm);
        model.put((Object)"selectedTerm", (Object)selectedTerm);
        List courseList = this.coursesSectionDao.getClassSchedule(request, selectedTerm.getCode(), termList);
        ArrayList<CourseSectionWrapper> classScheduleList = new ArrayList<CourseSectionWrapper>();
        ArrayList<CourseSectionWrapper> otherCourses = new ArrayList<CourseSectionWrapper>();
        for (Course course : courseList) {
            for (CourseSection courseSection : course.getCourseSections()) {
                PortletURL url = this.createCourseDetailUrl(course, courseSection, response, selectedTerm.getCode());
                if (courseSection.getCourseMeetings().size() > 0 && !((CourseMeeting)courseSection.getCourseMeetings().get(0)).getLocation().getDisplayName().equals("ONLINE")) {
                    for (CourseMeeting courseMeeting : courseSection.getCourseMeetings()) {
                        if (courseMeeting.getDayIds() == null) continue;
                        for (String day : courseMeeting.getDayIds()) {
                            CourseSectionWrapper classSchedule = new CourseSectionWrapper(course, courseSection, courseMeeting, day, url.toString());
                            classScheduleList.add(classSchedule);
                        }
                    }
                    continue;
                }
                CourseSectionWrapper classSchedule = new CourseSectionWrapper(course, courseSection, url.toString());
                otherCourses.add(classSchedule);
            }
        }
        Collections.sort(classScheduleList, CourseSectionWrapper.ClassScheduleComparator);
        Collections.sort(otherCourses, CourseSectionWrapper.OtherCourseComparator);
        model.put((Object)"otherCourses", otherCourses);
        model.put((Object)"classScheduleList", classScheduleList);
    }

    @ResourceMapping(value="jsonClassSchedule")
    public String jsonClassSchedule(PortletRequest request, MimeResponse response, ModelMap model, @RequestParam(value="termCode") String termCode) {
        this.getClassScheduleList(request, response, model, termCode);
        return "json";
    }

    @ResourceMapping(value="jsonCurrentClassSchedule")
    public String jsonCurrentClassSchedule(PortletRequest request, MimeResponse response, ModelMap model) {
        TermList termList = this.coursesSectionDao.getTermList(request);
        if (termList != null) {
            model.put((Object)"termList", (Object)termList);
            if (termList.getCurrentTerm() != null) {
                CoursesByTerm currentTermCourses = this.coursesSectionDao.getCoursesByTerm(request, termList.getCurrentTerm().getCode(), termList);
                model.put((Object)"currentTermCourses", (Object)currentTermCourses);
            } else {
                model.put((Object)"currentTermCourses", null);
            }
        }
        return "json";
    }

    @RequestMapping(params={"action=showClassSchedule"})
    public String viewClassSchedule(PortletRequest request, MimeResponse response, ModelMap model, @RequestParam(value="termCode") String termCode, @RequestParam(value="view") String view, @RequestParam(value="printView", required=false, defaultValue="false") Boolean printView) {
        this.getClassScheduleList(request, response, model, termCode);
        boolean isMobile = this.viewSelector.isMobile(request);
        String viewName = "";
        model.put((Object)PRINTVIEW, (Object)printView);
        model.put((Object)"isStandaloneSchedule", (Object)Boolean.parseBoolean(request.getPreferences().getValue(STANDALONE_SCHEDULE_PREFERENCE, "false")));
        if (view.equals("list")) {
            viewName = isMobile ? "myuwcourses/classScheduleList-jQM" : "myuwcourses/classScheduleList";
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                model.put((Object)"classScheduleListJson", (Object)mapper.writeValueAsString((Object)((List)model.get((Object)"classScheduleList"))));
            }
            catch (IOException e) {
                String msg = "Failed to return jsonClassSchedule response";
                this.logger.error(msg, (Throwable)e);
                throw new RuntimeException(msg);
            }
            viewName = isMobile ? "myuwcourses/classScheduleGrid-jQM" : "myuwcourses/classScheduleGrid";
        }
        return viewName;
    }

    @ActionMapping
    public void copyActionParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        actionResponse.setRenderParameters(actionRequest.getParameterMap());
    }

    @ModelAttribute(value="displayCourseUpdates")
    public Boolean getDisplayCourseUpdates(PortletRequest req) {
        String val = req.getPreferences().getValue(DISPLAY_COURSE_UPDATES_PREFERENCE, Boolean.TRUE.toString());
        return Boolean.valueOf(val);
    }

    @ModelAttribute(value="displayCourseBooks")
    public Boolean getDisplayCourseBooks(PortletRequest req) {
        String val = req.getPreferences().getValue(DISPLAY_COURSE_BOOKS_PREFERENCE, Boolean.TRUE.toString());
        return Boolean.valueOf(val);
    }

    protected String getSelectedTermCode(PortletRequest portletRequest, String requestTermCode) {
        PortletSession portletSession = portletRequest.getPortletSession();
        if (requestTermCode != null) {
            portletSession.setAttribute(TERMCODE, (Object)requestTermCode);
            return requestTermCode;
        }
        return (String)portletSession.getAttribute(TERMCODE);
    }

    protected Term getSelectedTerm(String termCode, TermList termList) {
        if (termCode == null) {
            return termList.getCurrentTerm();
        }
        return termList.getTerm(termCode);
    }

    private String getPVI(List<AdditionalInfo> addInfoList) {
        for (AdditionalInfo addInfo : addInfoList) {
            if (!"pvi".equals(addInfo.getKey())) continue;
            return addInfo.getValue();
        }
        return null;
    }

    private PortletURL createCourseDetailUrl(Course course, CourseSection section, MimeResponse response, String term) {
        PortletURL url = response.createRenderURL();
        url.setParameter(CLASSNBR, section.getId());
        url.setParameter("action", "showCourse");
        url.setParameter(COURSEID, course.getId());
        url.setParameter(SUBJECTCODE, course.getCourseDepartment().getCode());
        url.setParameter(TERMCODE, term);
        url.setParameter(CATALOGNBR, course.getCode());
        url.setParameter(COURSECODE, course.getCode());
        return url;
    }

    private List<CourseSectionMeetingWrapper> getCourseMeetingsWrapperList(Course course, PortletPreferences prefs, boolean isMobile, String termCode) {
        ArrayList<CourseSectionMeetingWrapper> courseSectionMeetingWrapperList = new ArrayList<CourseSectionMeetingWrapper>();
        for (CourseSection courseSection : course.getCourseSections()) {
            this.logger.debug("DUMPING COURSE MEETINGS >>>>>>>>>>>" + courseSection.getCode());
            this.logger.debug("DUMPING COURSE MEETINGS SIZE>>>>>>>>>>>" + courseSection.getCourseMeetings().size());
            courseSectionMeetingWrapperList.add(new CourseSectionMeetingWrapper(courseSection, prefs, isMobile, termCode, this.urlService));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DUMPING COURSE MEETINGS>>>>>>>>>>>");
            new CourseSectionMeetingWrapper().printCourseSectionWrapperList(courseSectionMeetingWrapperList);
        }
        return courseSectionMeetingWrapperList;
    }
}

