/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.grades.mvc;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.jasig.portlet.utils.mvc.IViewSelector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class FinalGradesPortletController {
    public static final String TERMCODE = "termCode";
    private ICoursesDao coursesDao;
    private IViewSelector viewSelector;

    @Autowired
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @Autowired
    @Qualifier(value="finalGradesServiceDao")
    public void setCoursesDao(ICoursesDao coursesDao) {
        this.coursesDao = coursesDao;
    }

    @RenderMapping
    public ModelAndView getGrades(PortletRequest request, @RequestParam(required=false) String termCode) {
        boolean isMobile;
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletPreferences prefs = request.getPreferences();
        request.getPortletSession().setAttribute("helpDeskURL", (Object)prefs.getValue("helpDeskURL", ""));
        TermList termList = this.coursesDao.getTermList(request);
        model.put("termList", termList);
        termCode = this.getSelectedTermCode(request, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm != null) {
            CoursesByTerm courseSummary = this.coursesDao.getCoursesByTerm(request, selectedTerm.getCode());
            model.put("courseSummary", courseSummary);
            model.put("selectedTerm", selectedTerm);
        }
        String viewName = (isMobile = this.viewSelector.isMobile(request)) ? "final-grades/grades-jQM" : "final-grades/grades";
        return new ModelAndView(viewName, model);
    }

    @ResourceMapping(value="gradesUpdate")
    public ModelAndView getCoursesSummary(ResourceRequest resourceRequest, @RequestParam String termCode) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        TermList termList = this.coursesDao.getTermList((PortletRequest)resourceRequest);
        model.put("termList", termList);
        termCode = this.getSelectedTermCode((PortletRequest)resourceRequest, termCode);
        Term selectedTerm = this.getSelectedTerm(termCode, termList);
        if (selectedTerm == null) {
            throw new IllegalArgumentException("Could not find term for code: " + termCode);
        }
        CoursesByTerm courseSummary = this.coursesDao.getCoursesByTerm((PortletRequest)resourceRequest, selectedTerm.getCode());
        model.put("courseSummary", courseSummary);
        model.put("selectedTerm", selectedTerm);
        String viewName = "final-grades/fragments/gradesUpdate";
        return new ModelAndView("final-grades/fragments/gradesUpdate", model);
    }

    @ActionMapping
    public void copyActionParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        actionResponse.setRenderParameters(actionRequest.getParameterMap());
    }

    protected String getSelectedTermCode(PortletRequest portletRequest, String requestTermCode) {
        PortletSession portletSession = portletRequest.getPortletSession();
        if (requestTermCode != null) {
            portletSession.setAttribute(TERMCODE, (Object)requestTermCode);
            return requestTermCode;
        }
        return (String)portletSession.getAttribute(TERMCODE);
    }

    protected Term getSelectedTerm(String termCode, TermList termList) {
        if (termCode == null) {
            return termList.getCurrentTerm();
        }
        return termList.getTerm(termCode);
    }
}

