/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.dining.dao;

import java.io.Serializable;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.dining.dao.IDiningMenuDao;
import org.jasig.portlet.dining.model.menu.xml.DiningHall;
import org.jasig.portlet.dining.model.menu.xml.Menu;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractXmlBasedDiningMenuDaoImpl
implements IDiningMenuDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private List<String> diningHalls;

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setDiningHalls(List<String> diningHalls) {
        this.diningHalls = diningHalls;
    }

    public List<String> getDiningHalls(PortletRequest request) {
        return this.diningHalls;
    }

    public DiningHall getMenu(PortletRequest request, String diningHall) {
        String key = "diningHallMenu.".concat(diningHall);
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            String xml = this.getXmlMenu(request, diningHall);
            DiningHall hall = this.getMenu(xml);
            cachedElement = new Element((Serializable)((Object)key), (Serializable)hall);
            this.cache.put(cachedElement);
            return hall;
        }
        return (DiningHall)cachedElement.getValue();
    }

    protected abstract String getXmlMenu(PortletRequest var1, String var2);

    protected DiningHall getMenu(String xml) {
        try {
            String packageName = Menu.class.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            DiningHall hall = (DiningHall)u.unmarshal(IOUtils.toInputStream((String)xml));
            return hall;
        }
        catch (JAXBException e) {
            this.log.error((Object)"Exception deserializing menu xml", (Throwable)e);
            return null;
        }
    }
}

