/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import javax.mail.Authenticator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountDao;
import org.jasig.portlet.emailpreview.dao.IMailStoreDao;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailMessageController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IEmailAccountDao accountDao;
    private IMailStoreDao mailStoreDao;
    private AjaxPortletSupportService ajaxPortletSupportService;
    private IAuthenticationServiceRegistry authServiceRegistry;

    @Autowired(required=true)
    public void setAccountInfoDao(IEmailAccountDao accountInfoDao) {
        this.accountDao = accountInfoDao;
    }

    @Autowired(required=true)
    public void setMailStoreDao(IMailStoreDao mailStoreDao) {
        this.mailStoreDao = mailStoreDao;
    }

    @Autowired(required=true)
    public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
        this.ajaxPortletSupportService = ajaxPortletSupportService;
    }

    @Autowired(required=true)
    public void setAuthenticationServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @RequestMapping(params={"action=emailMessage"})
    public void getAccountSummary(ActionRequest request, ActionResponse response, @RequestParam(value="messageNum") int messageNum) {
        try {
            MailStoreConfiguration config = this.mailStoreDao.getConfiguration((PortletRequest)request);
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            Authenticator auth = authService.getAuthenticator((PortletRequest)request, config);
            EmailMessage message = this.accountDao.retrieveMessage(config, auth, messageNum);
            HashMap<String, EmailMessage> model = new HashMap<String, EmailMessage>();
            model.put("message", message);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, request, response);
        }
        catch (Exception ex) {
            this.log.error((Object)"Error encountered while attempting to retrieve message", (Throwable)ex);
        }
    }
}

