/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IMailStoreDao;
import org.jasig.portlet.emailpreview.mvc.Attribute;
import org.jasig.portlet.emailpreview.mvc.MailStoreConfigurationForm;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"CONFIG"})
public class MailStoreConfigurationController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IMailStoreDao mailStoreDao;
    private List<String> protocols;
    private ILinkServiceRegistry linkServiceRegistry;
    private IAuthenticationServiceRegistry authServiceRegistry;

    @Autowired(required=true)
    public void setAccountDao(IMailStoreDao mailStoreDao) {
        this.mailStoreDao = mailStoreDao;
    }

    @Resource(name="protocols")
    @Required
    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @Autowired(required=true)
    public void setLinkServiceRegistry(ILinkServiceRegistry linkServiceRegistry) {
        this.linkServiceRegistry = linkServiceRegistry;
    }

    @Autowired(required=true)
    public void setAuthServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @RequestMapping
    public String getAccountFormView() {
        return "config";
    }

    @RequestMapping(params={"action=updateConfiguration"})
    public void saveAccountConfiguration(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") MailStoreConfigurationForm form, @RequestParam(value="save", required=false) String save) throws PortletModeException {
        if (StringUtils.isNotBlank((String)save)) {
            MailStoreConfiguration config = new MailStoreConfiguration();
            config.setHost(form.getHost());
            config.setPort(form.getPort());
            config.setProtocol(form.getProtocol());
            config.setInboxFolderName(form.getInboxFolderName());
            config.setAuthenticationServiceKey(form.getAuthenticationServiceKey());
            config.setLinkServiceKey(form.getLinkServiceKey());
            config.setConnectionTimeout(form.getConnectionTimeout());
            config.setTimeout(form.getTimeout());
            for (Map.Entry entry : form.getJavaMailProperties().entrySet()) {
                config.getJavaMailProperties().put(entry.getKey(), ((Attribute)entry.getValue()).getValue());
            }
            for (Map.Entry entry : form.getAdditionalProperties().entrySet()) {
                config.getAdditionalProperties().put(entry.getKey(), ((Attribute)entry.getValue()).getValue());
            }
            this.log.debug((Object)("Saving new mail store configuration: {" + config.toString() + "}"));
            this.mailStoreDao.saveConfiguration(request, config);
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="form")
    public MailStoreConfigurationForm getConfigurationForm(PortletRequest request) {
        MailStoreConfiguration config = this.mailStoreDao.getConfiguration(request);
        MailStoreConfigurationForm form = new MailStoreConfigurationForm();
        form.setHost(config.getHost());
        form.setPort(config.getPort());
        form.setProtocol(config.getProtocol());
        form.setInboxFolderName(config.getInboxFolderName());
        form.setAuthenticationServiceKey(config.getAuthenticationServiceKey());
        form.setLinkServiceKey(config.getLinkServiceKey());
        form.setConnectionTimeout(config.getConnectionTimeout());
        form.setTimeout(config.getTimeout());
        for (Map.Entry entry : config.getJavaMailProperties().entrySet()) {
            form.getJavaMailProperties().put(entry.getKey(), new Attribute((String)entry.getValue()));
        }
        for (Map.Entry entry : config.getAdditionalProperties().entrySet()) {
            form.getAdditionalProperties().put(entry.getKey(), new Attribute((String)entry.getValue()));
        }
        return form;
    }

    @ModelAttribute(value="serviceParameters")
    public Map<String, List<ConfigurationParameter>> getServiceParameters(PortletRequest request) {
        IAuthenticationService authService;
        HashMap<String, List<ConfigurationParameter>> parameters = new HashMap<String, List<ConfigurationParameter>>();
        MailStoreConfiguration config = this.mailStoreDao.getConfiguration(request);
        IEmailLinkService linkService = this.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
        if (linkService != null) {
            parameters.put("linkParameters", linkService.getAdminConfigurationParameters());
        }
        if ((authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey())) != null) {
            parameters.put("authParameters", authService.getAdminConfigurationParameters());
        }
        return parameters;
    }

    @ModelAttribute(value="protocols")
    public List<String> getProtocols() {
        return this.protocols;
    }

    @ModelAttribute(value="linkServices")
    public Collection<IEmailLinkService> getLinkServices() {
        return this.linkServiceRegistry.getServices();
    }

    @ModelAttribute(value="authServices")
    public Collection<IAuthenticationService> getAuthServices() {
        return this.authServiceRegistry.getServices();
    }
}

