/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountInfo;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailMessageContent;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountDao;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class EmailAccountDaoImpl
implements IEmailAccountDao,
InitializingBean,
ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Policy policy;
    private ApplicationContext ctx;
    private String filePath = "classpath:antisamy.xml";

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public void setSecurityFile(String path) {
        this.filePath = path;
    }

    public void afterPropertiesSet() throws Exception {
        InputStream stream = this.ctx.getResource(this.filePath).getInputStream();
        this.policy = Policy.getInstance((InputStream)stream);
    }

    public AccountInfo retrieveEmailAccountInfo(MailStoreConfiguration storeConfig, Authenticator auth, int start, int messageCount) throws EmailPreviewException {
        Folder inbox = null;
        try {
            inbox = this.getUserInbox(storeConfig, auth);
            inbox.open(1);
            long startTime = System.currentTimeMillis();
            List unreadMessages = this.getEmailMessages(inbox, start, messageCount);
            int totalMessageCount = this.getTotalEmailMessageCount(inbox);
            int unreadMessageCount = this.getUnreadEmailMessageCount(inbox);
            if (this.log.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                int unreadMessageToDisplayCount = unreadMessages.size();
                this.log.debug((Object)("Finished looking up email messages. Inbox size: " + totalMessageCount + " Unread message count: " + unreadMessageToDisplayCount + " Total elapsed time: " + elapsedTime + "ms " + " Time per message in inbox: " + (totalMessageCount == 0 ? 0L : elapsedTime / (long)totalMessageCount) + "ms" + " Time per unread message: " + (unreadMessageToDisplayCount == 0 ? 0L : elapsedTime / (long)unreadMessageToDisplayCount) + "ms"));
            }
            inbox.close(false);
            AccountInfo acountInfo = new AccountInfo();
            acountInfo.setMessages(unreadMessages);
            acountInfo.setUnreadMessageCount(unreadMessageCount);
            acountInfo.setTotalMessageCount(totalMessageCount);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Successfully retrieved email account info");
            }
            AccountInfo accountInfo = acountInfo;
            return accountInfo;
        }
        catch (MessagingException me) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)me);
            throw new EmailPreviewException((Throwable)me);
        }
        catch (IOException e) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException((Throwable)e);
        }
        catch (ScanException e) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException((Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException((Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {}
            }
        }
    }

    private Folder getUserInbox(MailStoreConfiguration storeConfig, Authenticator authenticator) throws MessagingException {
        try {
            int timeout;
            Properties mailProperties = new Properties();
            mailProperties.put("mail.store.protocol", storeConfig.getProtocol());
            mailProperties.put("mail.host", storeConfig.getHost());
            mailProperties.put("mail.port", (Object)storeConfig.getPort());
            mailProperties.put("mail.debug", (Object)true);
            String protocolPropertyPrefix = "mail." + storeConfig.getProtocol() + ".";
            int connectionTimeout = storeConfig.getConnectionTimeout();
            if (connectionTimeout >= 0) {
                mailProperties.put(protocolPropertyPrefix + "connectiontimeout", (Object)connectionTimeout);
            }
            if ((timeout = storeConfig.getTimeout()) >= 0) {
                mailProperties.put(protocolPropertyPrefix + "timeout", (Object)timeout);
            }
            for (Map.Entry property : storeConfig.getJavaMailProperties().entrySet()) {
                mailProperties.put(property.getKey(), property.getValue());
            }
            Session session = Session.getInstance((Properties)mailProperties, (Authenticator)authenticator);
            Store store = session.getStore();
            store.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Mail store created");
            }
            Folder root = store.getDefaultFolder();
            Folder inboxFolder = root.getFolder(storeConfig.getInboxFolderName());
            return inboxFolder;
        }
        catch (AuthenticationFailedException e) {
            throw new MailAuthenticationException();
        }
    }

    protected List<EmailMessage> getEmailMessages(Folder mailFolder, int pageStart, int messageCount) throws MessagingException, IOException, ScanException, PolicyException {
        int totalMessageCount = mailFolder.getMessageCount();
        int start = Math.max(1, totalMessageCount - pageStart - (messageCount - 1));
        int end = Math.max(totalMessageCount - pageStart, 1);
        Message[] messages = mailFolder.getMessages(start, end);
        long startTime = System.currentTimeMillis();
        FetchProfile profile = new FetchProfile();
        profile.add(FetchProfile.Item.ENVELOPE);
        profile.add(FetchProfile.Item.FLAGS);
        mailFolder.fetch(messages, profile);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Time elapsed while fetching message headers:" + (System.currentTimeMillis() - startTime)));
        }
        LinkedList<EmailMessage> unreadEmails = new LinkedList<EmailMessage>();
        for (Message currentMessage : messages) {
            EmailMessage emailMessage = this.wrapMessage(currentMessage, false);
            unreadEmails.add(emailMessage);
        }
        Collections.reverse(unreadEmails);
        return unreadEmails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmailMessage retrieveMessage(MailStoreConfiguration storeConfig, Authenticator auth, int messageNum) {
        Folder inbox = null;
        try {
            inbox = this.getUserInbox(storeConfig, auth);
            inbox.open(1);
            Message message = inbox.getMessage(messageNum);
            EmailMessage emailMessage = this.wrapMessage(message, true);
            inbox.close(false);
            EmailMessage emailMessage2 = emailMessage;
            return emailMessage2;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while retrieving individual message", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"IO exception while retrieving individual message", (Throwable)e);
        }
        catch (ScanException e) {
            this.log.error((Object)"AntiSamy scanning exception while retrieving individual message", (Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error((Object)"AntiSamy policy exception while retrieving individual message", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    protected EmailMessage wrapMessage(Message currentMessage, boolean populateContent) throws MessagingException, IOException, ScanException, PolicyException {
        EmailMessage emailMessage = new EmailMessage();
        emailMessage.setMessageNumber(currentMessage.getMessageNumber());
        Address[] addresses = currentMessage.getFrom();
        String sender = addresses[0].toString();
        emailMessage.setSender(sender);
        String subject = currentMessage.getSubject();
        if (!StringUtils.isBlank((String)subject)) {
            AntiSamy as = new AntiSamy();
            CleanResults cr = as.scan(subject, this.policy);
            subject = cr.getCleanHTML();
        }
        emailMessage.setSubject(subject);
        emailMessage.setSentDate(currentMessage.getSentDate());
        emailMessage.setUnread(!currentMessage.isSet(Flags.Flag.SEEN));
        emailMessage.setAnswered(currentMessage.isSet(Flags.Flag.ANSWERED));
        emailMessage.setDeleted(currentMessage.isSet(Flags.Flag.DELETED));
        if (populateContent) {
            Object content = currentMessage.getContent();
            EmailMessageContent body = this.getContentString(content, currentMessage.getContentType());
            String contentString = body.getContentString();
            if (!StringUtils.isBlank((String)contentString)) {
                AntiSamy as = new AntiSamy();
                CleanResults cr = as.scan(contentString, this.policy);
                subject = cr.getCleanHTML();
            }
            body.setContentString(contentString);
            emailMessage.setContent(body);
        }
        return emailMessage;
    }

    protected EmailMessageContent getContentString(Object content, String mimeType) throws IOException, MessagingException {
        if (content instanceof String) {
            return new EmailMessageContent((String)content, this.isHtml(mimeType));
        }
        if (content instanceof MimeMultipart) {
            Multipart m = (Multipart)content;
            int parts = m.getCount();
            for (int i = parts - 1; i >= 0; --i) {
                EmailMessageContent result = null;
                BodyPart part = m.getBodyPart(i);
                Object partContent = part.getContent();
                String contentType = part.getContentType();
                boolean isHtml = this.isHtml(contentType);
                this.log.debug((Object)("Examining Multipart " + i + " with type " + contentType + " and class " + partContent.getClass()));
                if (partContent instanceof String) {
                    result = new EmailMessageContent((String)partContent, isHtml);
                } else if (partContent instanceof InputStream && contentType.startsWith("text/html")) {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)((InputStream)partContent), (Writer)writer);
                    result = new EmailMessageContent(writer.toString(), isHtml);
                } else if (partContent instanceof MimeMultipart) {
                    result = this.getContentString(partContent, contentType);
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected boolean isHtml(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return (mimeType = mimeType.trim().toLowerCase()).contains("text/html");
    }

    protected int getTotalEmailMessageCount(Folder inbox) throws MessagingException {
        return inbox.getMessageCount();
    }

    protected int getUnreadEmailMessageCount(Folder inbox) throws MessagingException {
        return inbox.getUnreadMessageCount();
    }
}

