/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.SimplePasswordAuthenticator;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.springframework.stereotype.Component;

@Component(value="cachedPasswordAuthenticationService")
public class CachedPasswordAuthenticationServiceImpl
implements IAuthenticationService {
    private static final String KEY = "cachedPassword";
    protected static final String USERNAME_SUFFIX_KEY = "usernameSuffix";
    private String usernameKey = "user.login.id";
    private String passwordKey = "password";

    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String username = (String)userInfo.get(this.usernameKey);
        String password = (String)userInfo.get(this.passwordKey);
        String usernameSuffix = (String)config.getAdditionalProperties().get(USERNAME_SUFFIX_KEY);
        if (!StringUtils.isBlank((String)usernameSuffix)) {
            username = username.concat(usernameSuffix);
        }
        return new SimplePasswordAuthenticator(username, password);
    }

    public String getKey() {
        return KEY;
    }

    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        ConfigurationParameter param = new ConfigurationParameter();
        param.setKey(USERNAME_SUFFIX_KEY);
        param.setLabel("Username Suffix");
        return Collections.singletonList(param);
    }

    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return Collections.emptyList();
    }
}

