/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/parameters"})
public class AdditionalParametersController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ILinkServiceRegistry linkServiceRegistry;
    private IAuthenticationServiceRegistry authServiceRegistry;

    @Autowired(required=true)
    public void setLinkServiceRegistry(ILinkServiceRegistry linkServiceRegistry) {
        this.linkServiceRegistry = linkServiceRegistry;
    }

    @Autowired(required=true)
    public void setAuthenticationServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView getParameters(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="linkService") String linkServiceKey, @RequestParam(value="authService") String authServiceKey) throws IOException {
        try {
            IEmailLinkService linkService;
            HashMap<String, List> model = new HashMap<String, List>();
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(authServiceKey);
            if (authService != null) {
                List authParams = authService.getAdminConfigurationParameters();
                model.put("authParams", authParams);
            }
            if ((linkService = this.linkServiceRegistry.getEmailLinkService(linkServiceKey)) != null) {
                List linkParams = linkService.getAdminConfigurationParameters();
                model.put("linkParams", linkParams);
            }
            return new ModelAndView("jsonView", model);
        }
        catch (Exception ex) {
            this.log.error((Object)"Error encountered attempting to retrieve parameter definitions", (Throwable)ex);
            response.sendError(500);
            return null;
        }
    }
}

