/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview;

import java.util.Collections;
import java.util.List;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.UIDFolder;
import org.jasig.portlet.emailpreview.EmailMessage;

public class AccountInfo {
    private final int numUnreadMessages;
    private final int numTotalMessages;
    private final List<EmailMessage> messages;
    private final int messagesStart;
    private final int messagesCount;
    private final boolean deleteSupported;

    public AccountInfo(Folder inbox, List<EmailMessage> messages, int messagesStart, int messagesCount) throws MessagingException {
        this.numUnreadMessages = inbox.getUnreadMessageCount();
        this.numTotalMessages = inbox.getMessageCount();
        this.messages = Collections.unmodifiableList(messages);
        this.messagesStart = messagesStart;
        this.messagesCount = messagesCount;
        this.deleteSupported = inbox instanceof UIDFolder;
    }

    public int getUnreadMessageCount() {
        return this.numUnreadMessages;
    }

    public int getTotalMessageCount() {
        return this.numTotalMessages;
    }

    public List<EmailMessage> getMessages() {
        return this.messages;
    }

    public int getMessagesStart() {
        return this.messagesStart;
    }

    public int getMessagesCount() {
        return this.messagesCount;
    }

    public boolean isDeleteSupported() {
        return this.deleteSupported;
    }
}

