/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview;

import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.time.FastDateFormat;
import org.jasig.portlet.emailpreview.EmailMessageContent;

public final class EmailMessage {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"h:mm a MMM d, yyyy");
    private static final String CONTENT_TYPE_ATTACHMENTS_PATTERN = "multipart/mixed;";
    private final Message message;
    private final Long uid;
    private final String sender;
    private final String subject;
    private final Date sentDate;
    private final boolean unread;
    private final boolean answered;
    private final boolean deleted;
    private final boolean multipart;
    private final String contentType;
    private final EmailMessageContent content;

    public EmailMessage(Message message, Long uid, String subject) throws MessagingException {
        this(message, uid, subject, null);
    }

    public EmailMessage(Message message, Long uid, String subject, EmailMessageContent content) throws MessagingException {
        if (message == null) {
            String msg = "Argument 'message' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        this.message = message;
        this.uid = uid;
        Address[] addr = message.getFrom();
        this.sender = addr != null && addr.length != 0 ? addr[0].toString() : null;
        this.subject = subject;
        this.sentDate = message.getSentDate();
        this.unread = !message.isSet(Flags.Flag.SEEN);
        this.answered = message.isSet(Flags.Flag.ANSWERED);
        this.deleted = message.isSet(Flags.Flag.DELETED);
        this.multipart = message.getContentType().startsWith(CONTENT_TYPE_ATTACHMENTS_PATTERN);
        this.contentType = message.getContentType();
        this.content = content;
    }

    public int getMessageNumber() {
        return this.message.getMessageNumber();
    }

    public Long getUid() {
        return this.uid;
    }

    public Date getSentDate() {
        return new Date(this.sentDate.getTime());
    }

    public String getSentDateString() {
        return DATE_FORMAT.format(this.sentDate);
    }

    public String getSender() {
        return this.sender;
    }

    public String getSenderName() {
        return this.getSender().split("\\s*<")[0];
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean isUnread() {
        return this.unread;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getContentType() {
        return this.contentType;
    }

    public EmailMessageContent getContent() {
        return this.content;
    }
}

