/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.lang.constant.Constable;
import java.util.HashMap;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailSummaryController {
    public static final String PAGE_SIZE_KEY = "pageSize";
    public static final String ALLOW_DELETE_KEY = "allowDelete";
    private static final String SHOW_CONFIG_LINK_KEY = "showConfigLink";
    private String adminRoleName = "admin";

    public void setAdminRoleName(String adminRoleName) {
        this.adminRoleName = adminRoleName;
    }

    @RequestMapping
    public ModelAndView showEmail(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Constable> model = new HashMap<String, Constable>();
        PortletPreferences prefs = request.getPreferences();
        int pageSize = Integer.parseInt(prefs.getValue(PAGE_SIZE_KEY, "10"));
        model.put(PAGE_SIZE_KEY, Integer.valueOf(pageSize));
        boolean showConfigLink = Boolean.valueOf(prefs.getValue(SHOW_CONFIG_LINK_KEY, "false"));
        if (showConfigLink) {
            showConfigLink = request.isUserInRole(this.adminRoleName);
        }
        model.put(SHOW_CONFIG_LINK_KEY, Boolean.valueOf(showConfigLink));
        boolean allowDelete = Boolean.valueOf(prefs.getValue(ALLOW_DELETE_KEY, "false"));
        model.put(ALLOW_DELETE_KEY, Boolean.valueOf(allowDelete));
        boolean supportsEdit = request.isPortletModeAllowed(PortletMode.EDIT);
        model.put("supportsEdit", Boolean.valueOf(supportsEdit));
        return new ModelAndView("preview", model);
    }
}

