/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.SimplePasswordAuthenticator;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.springframework.stereotype.Component;

@Component(value="cachedPasswordAuthenticationService")
public class CachedPasswordAuthenticationServiceImpl
implements IAuthenticationService {
    private static final String KEY = "cachedPassword";
    private static final String USERNAME_ATTRIBUTE = "user.login.id";
    private static final String PASSWORD_ATTRIBUTE = "password";
    private Map<String, ConfigurationParameter> configParams;

    public CachedPasswordAuthenticationServiceImpl() {
        HashMap<String, ConfigurationParameter> m = new HashMap<String, ConfigurationParameter>();
        for (ConfigurationParameter param : this.getAdminConfigurationParameters()) {
            m.put(param.getKey(), param);
        }
        for (ConfigurationParameter param : this.getUserConfigurationParameters()) {
            m.put(param.getKey(), param);
        }
        this.configParams = Collections.unmodifiableMap(m);
    }

    @Override
    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return this.configParams;
    }

    @Override
    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String password = (String)userInfo.get(PASSWORD_ATTRIBUTE);
        return new SimplePasswordAuthenticator(this.getMailAccountName(request, config), password);
    }

    @Override
    public String getMailAccountName(PortletRequest request, MailStoreConfiguration config) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String username = (String)userInfo.get(USERNAME_ATTRIBUTE);
        String usernameSuffix = config.getUsernameSuffix();
        if (!StringUtils.isBlank((String)usernameSuffix)) {
            username = username.concat(usernameSuffix);
        }
        return username;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return Collections.emptyList();
    }
}

