/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxUpdatePageSizeController {
    private static final String STATUS_KEY = "success";
    private AjaxPortletSupportService ajaxPortletSupportService;
    private final Log log = LogFactory.getLog(this.getClass());

    @Autowired(required=true)
    public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
        this.ajaxPortletSupportService = ajaxPortletSupportService;
    }

    @RequestMapping(params={"action=updatePageSize"})
    public void updatePageSize(ActionRequest req, ActionResponse res, @RequestParam(value="newPageSize") int newPageSize) throws Exception {
        PortletPreferences prefs = req.getPreferences();
        HashMap<String, Comparable<Boolean>> model = new HashMap<String, Comparable<Boolean>>();
        if (!prefs.isReadOnly("pageSize")) {
            prefs.setValue("pageSize", Integer.toString(newPageSize));
            prefs.store();
            model.put(STATUS_KEY, Boolean.valueOf(true));
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
        } else {
            if (this.log.isDebugEnabled()) {
                String msg = "Ignoring chanhe to pageSize for the following user because the preference is read only:  " + req.getRemoteUser();
                this.log.debug((Object)msg);
            }
            model.put("errorCode", Integer.valueOf(500));
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/error", model, req, res);
        }
    }
}

