/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountDao;
import org.jasig.portlet.emailpreview.dao.IMailStoreDao;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.mvc.Attribute;
import org.jasig.portlet.emailpreview.mvc.MailStoreConfigurationForm;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"EDIT"})
public final class EditPreferencesController {
    private static final String UNCHANGED_PASSWORD = "uNch@ng3d.pswd!";
    private static final String CONFIG_FORM_KEY = "org.jasig.portlet.emailpreview.controller.CONFIG_FORM_KEY";
    private IMailStoreDao mailStoreDao;
    IEmailAccountDao emailAccountDao;
    private IAuthenticationServiceRegistry authServiceRegistry;
    private List<String> protocols;
    private final Log log = LogFactory.getLog(this.getClass());

    @RequestMapping
    public ModelAndView getAccountFormView(RenderRequest req) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        MailStoreConfiguration config = this.mailStoreDao.getConfiguration((PortletRequest)req);
        PortletSession session = req.getPortletSession(false);
        MailStoreConfigurationForm form = (MailStoreConfigurationForm)session.getAttribute(CONFIG_FORM_KEY);
        if (form == null) {
            form = MailStoreConfigurationForm.create((IMailStoreDao)this.mailStoreDao, (PortletRequest)req);
        } else {
            session.removeAttribute(CONFIG_FORM_KEY);
        }
        model.put("form", form);
        model.put("disableProtocol", this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.PROTOCOL));
        model.put("disableHost", this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.HOST));
        model.put("disablePort", this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.PORT));
        model.put("disableAuthService", this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.AUTHENTICATION_SERVICE_KEY));
        model.put("protocols", this.protocols);
        HashMap<String, IAuthenticationService> authServices = new HashMap<String, IAuthenticationService>();
        for (String key : config.getAllowableAuthenticationServiceKeys()) {
            IAuthenticationService auth = this.authServiceRegistry.getAuthenticationService(key);
            if (auth != null) {
                authServices.put(key, auth);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn((Object)("Portlet specified an allowable Authentication Service that is unknown to the registry:  '" + key + "'"));
        }
        model.put("authenticationServices", authServices);
        if (form.getAdditionalProperties().containsKey(MailPreferences.PASSWORD.getKey())) {
            model.put("unchangedPassword", UNCHANGED_PASSWORD);
        }
        if (req.getParameter("errorMessage") != null) {
            model.put("errorMessage", req.getParameter("errorMessage"));
        }
        return new ModelAndView("editPreferences", model);
    }

    @RequestMapping(params={"action=updatePreferences"})
    public void updatePreferences(ActionRequest req, ActionResponse res) throws PortletModeException {
        MailStoreConfiguration config = this.mailStoreDao.getConfiguration((PortletRequest)req);
        MailStoreConfigurationForm form = MailStoreConfigurationForm.create((IMailStoreDao)this.mailStoreDao, (PortletRequest)req);
        String err = null;
        String mailAccountAtStart = (String)config.getAdditionalProperties().get(MailPreferences.MAIL_ACCOUNT.getKey());
        if (!this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.PROTOCOL)) {
            String protocol = req.getParameter(MailPreferences.PROTOCOL.getKey());
            String string = protocol = protocol != null ? protocol.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Receieved the following user input for Protocol:  '" + protocol + "'"));
            }
            if (!this.protocols.contains(protocol)) {
                throw new RuntimeException("Unsupported protocol:  " + protocol);
            }
            form.setProtocol(protocol);
            if (protocol.length() == 0 && err == null) {
                err = "Server Protocol is required";
            }
        }
        if (!this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.HOST)) {
            String host = req.getParameter(MailPreferences.HOST.getKey());
            String string = host = host != null ? host.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Receieved the following user input for Host:  '" + host + "'"));
            }
            form.setHost(host);
            if (host.length() == 0 && err == null) {
                err = "Server Name is required";
            }
        }
        if (!this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.PORT)) {
            String port = req.getParameter(MailPreferences.PORT.getKey());
            String string = port = port != null ? port.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Receieved the following user input for Port:  '" + port + "'"));
            }
            try {
                form.setPort(Integer.parseInt(port));
            }
            catch (NumberFormatException nfe) {
                this.log.debug((Object)nfe);
            }
            if (port.length() == 0 && err == null) {
                err = "Server Port is required";
            }
        }
        if (!this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.AUTHENTICATION_SERVICE_KEY)) {
            String authKey = req.getParameter(MailPreferences.AUTHENTICATION_SERVICE_KEY.getKey());
            String string = authKey = authKey != null ? authKey.trim() : "";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Receieved the following user input for AuthN Service Key:  '" + authKey + "'"));
            }
            if (authKey.length() != 0 && config.getAllowableAuthenticationServiceKeys().contains(authKey)) {
                form.setAuthenticationServiceKey(authKey);
            }
        }
        String ppPassword = null;
        if ("portletPreferences".equals(form.getAuthenticationServiceKey())) {
            if (!this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.MAIL_ACCOUNT)) {
                String mailAccount = req.getParameter(MailPreferences.MAIL_ACCOUNT.getKey());
                String string = mailAccount = mailAccount != null ? mailAccount.trim() : "";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Receieved the following user input for mailAccount:  '" + mailAccount + "'"));
                }
                if (mailAccount.length() != 0) {
                    form.getAdditionalProperties().put(MailPreferences.MAIL_ACCOUNT.getKey(), new Attribute(mailAccount));
                } else {
                    form.getAdditionalProperties().remove(MailPreferences.MAIL_ACCOUNT.getKey());
                }
            }
            if (!this.mailStoreDao.isReadOnly((PortletRequest)req, MailPreferences.PASSWORD)) {
                String password = req.getParameter("ppauth_password");
                String string = password = password != null ? password.trim() : "";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Receieved user input of the following length for Password:  " + password.length()));
                }
                if (!UNCHANGED_PASSWORD.equals(password)) {
                    if (password.length() != 0) {
                        ppPassword = password;
                    } else {
                        err = "Password is required for this form of authentication";
                        form.getAdditionalProperties().remove(MailPreferences.PASSWORD.getKey());
                    }
                }
            }
        }
        if (err == null) {
            config.setProtocol(form.getProtocol());
            config.setHost(form.getHost());
            config.setPort(form.getPort());
            config.setAuthenticationServiceKey(form.getAuthenticationServiceKey());
            if ("portletPreferences".equals(form.getAuthenticationServiceKey())) {
                Attribute username = (Attribute)form.getAdditionalProperties().get(MailPreferences.MAIL_ACCOUNT.getKey());
                config.getAdditionalProperties().put(MailPreferences.MAIL_ACCOUNT.getKey(), username.getValue());
                if (ppPassword != null) {
                    config.getAdditionalProperties().put(MailPreferences.PASSWORD.getKey(), ppPassword);
                }
            } else {
                config.getAdditionalProperties().remove(MailPreferences.MAIL_ACCOUNT.getKey());
                config.getAdditionalProperties().remove(MailPreferences.PASSWORD.getKey());
            }
            this.mailStoreDao.saveConfiguration(req, config);
            this.emailAccountDao.clearCache(req.getRemoteUser(), mailAccountAtStart);
            res.setPortletMode(PortletMode.VIEW);
        } else {
            res.setRenderParameter("errorMessage", err);
            req.getPortletSession().setAttribute(CONFIG_FORM_KEY, (Object)form);
        }
    }

    @Autowired(required=true)
    public void setAuthenticationServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @Autowired(required=true)
    public void setEmailAccountDao(IEmailAccountDao emailAccountDao) {
        this.emailAccountDao = emailAccountDao;
    }

    @Autowired(required=true)
    public void setMailStoreDao(IMailStoreDao mailStoreDao) {
        this.mailStoreDao = mailStoreDao;
    }

    @Resource(name="protocols")
    @Required
    public void setProtocols(List<String> protocols) {
        this.protocols = Collections.unmodifiableList(protocols);
    }
}

