/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.io.IOException;
import java.util.HashMap;
import javax.mail.Authenticator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountInfo;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountDao;
import org.jasig.portlet.emailpreview.dao.IMailStoreDao;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.jasig.portlet.emailpreview.exception.MailTimeoutException;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailAccountSummaryController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IEmailAccountDao accountDao;
    private IMailStoreDao mailStoreDao;
    private AjaxPortletSupportService ajaxPortletSupportService;
    private ILinkServiceRegistry linkServiceRegistry;
    private IAuthenticationServiceRegistry authServiceRegistry;

    @Autowired(required=true)
    public void setAccountInfoDao(IEmailAccountDao accountInfoDao) {
        this.accountDao = accountInfoDao;
    }

    @Autowired(required=true)
    public void setMailStoreDao(IMailStoreDao mailStoreDao) {
        this.mailStoreDao = mailStoreDao;
    }

    @Autowired(required=true)
    public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
        this.ajaxPortletSupportService = ajaxPortletSupportService;
    }

    @Autowired(required=true)
    public void setLinkServiceRegistry(ILinkServiceRegistry linkServiceRegistry) {
        this.linkServiceRegistry = linkServiceRegistry;
    }

    @Autowired(required=true)
    public void setAuthenticationServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @RequestMapping(params={"action=accountSummary"})
    public void getAccountSummary(ActionRequest request, ActionResponse response, @RequestParam(value="pageStart") int pageStart, @RequestParam(value="numberOfMessages") int numberOfMessages) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String username = request.getRemoteUser();
        try {
            IAuthenticationService authService;
            MailStoreConfiguration config = this.mailStoreDao.getConfiguration((PortletRequest)request);
            IEmailLinkService linkService = this.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
            if (linkService != null) {
                String inboxUrl = linkService.getInboxUrl((PortletRequest)request, config);
                model.put("inboxUrl", inboxUrl);
            }
            if ((authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey())) == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            Authenticator auth = authService.getAuthenticator((PortletRequest)request, config);
            String mailAccountName = authService.getMailAccountName((PortletRequest)request, config);
            if (Boolean.parseBoolean(request.getParameter("forceRefresh"))) {
                this.accountDao.clearCache(username, mailAccountName);
            }
            AccountInfo accountInfo = this.getAccountInfo(username, mailAccountName, config, auth, pageStart, numberOfMessages);
            model.put("accountInfo", accountInfo);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, request, response);
        }
        catch (MailAuthenticationException ex) {
            model.put("errorCode", 401);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/error", model, request, response);
            this.log.info((Object)("Authentication Failure (username='" + username + "') : " + ex.getMessage()));
        }
        catch (MailTimeoutException ex) {
            model.put("errorCode", 504);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/error", model, request, response);
            this.log.error((Object)"Mail Service Timeout", (Throwable)ex);
        }
        catch (Exception ex) {
            model.put("errorMessage", ex.getMessage());
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, request, response);
            this.log.error((Object)"Unanticipated Error", (Throwable)ex);
        }
    }

    private AccountInfo getAccountInfo(String username, String mailAccount, MailStoreConfiguration config, Authenticator auth, int start, int count) throws EmailPreviewException {
        AccountInfo rslt = this.accountDao.fetchAccountInfoFromStore(username, mailAccount, config, auth, start, count);
        if (rslt.getMessagesStart() != start || rslt.getMessagesCount() != count) {
            if (this.log.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Clearing AccountInfo cache for username '").append(username).append("', mailAccount '").append(mailAccount).append("':  start=[").append(rslt.getMessagesStart()).append(" prev, ").append(start).append(" current] ").append("count=[").append(rslt.getMessagesCount()).append(" prev, ").append(count).append(" current]");
                this.log.trace((Object)msg.toString());
            }
            this.accountDao.clearCache(username, mailAccount);
            rslt = this.accountDao.fetchAccountInfoFromStore(username, mailAccount, config, auth, start, count);
        }
        return rslt;
    }
}

