/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MessageUtils {
    private static final String CLICKABLE_URLS_REGEX = "\\b((?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$]))";
    private static final Pattern CLICKABLE_URLS_PATTERN = Pattern.compile("\\b((?:(?:https?|ftp|file)://|www\\.|ftp\\.)(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[-A-Z0-9+&@#/%=~_|$?!:,.])*(?:\\([-A-Z0-9+&@#/%=~_|$?!:,.]*\\)|[A-Z0-9+&@#/%=~_|$]))", 2);
    private static final String CLICKABLE_URLS_PART1 = "<a href=\"";
    private static final String CLICKABLE_URLS_PART2 = "\" target=\"_new\">";
    private static final String CLICKABLE_URLS_PART3 = "</a>";
    private static final Log LOG = LogFactory.getLog(MessageUtils.class);

    public static String addClickableUrlsToMessageBody(String msgBody) {
        if (msgBody == null) {
            String msg = "Argument 'msgBody' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        StringBuffer rslt = new StringBuffer();
        Matcher m = CLICKABLE_URLS_PATTERN.matcher(msgBody);
        while (m.find()) {
            String url;
            StringBuilder bldr = new StringBuilder();
            String text = m.group(1);
            String string = url = text.startsWith("www.") ? "http://" + text : text;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Making embedded URL '" + text + "' clickable at the following href:  " + url));
            }
            bldr.append(CLICKABLE_URLS_PART1).append(url).append(CLICKABLE_URLS_PART2).append(text).append(CLICKABLE_URLS_PART3);
            m.appendReplacement(rslt, bldr.toString());
        }
        m.appendTail(rslt);
        return rslt.toString();
    }
}

