/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.io.IOException;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.jasig.portlet.emailpreview.exception.MailTimeoutException;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailAccountSummaryController {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=true)
    private IEmailAccountService accountDao;
    @Autowired(required=true)
    private AjaxPortletSupportService ajaxPortletSupportService;
    public static final String FORCE_REFRESH_PARAMETER = "forceRefresh";

    @RequestMapping(params={"action=accountSummary"})
    public void getAccountSummary(ActionRequest req, ActionResponse res, @RequestParam(value="pageStart") int start, @RequestParam(value="numberOfMessages") int max) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String username = req.getRemoteUser();
        try {
            AccountSummary accountSummary;
            boolean refresh = Boolean.valueOf(req.getParameter(FORCE_REFRESH_PARAMETER));
            if (req.getPortletSession().getAttribute(FORCE_REFRESH_PARAMETER) != null) {
                refresh = true;
                req.getPortletSession().removeAttribute(FORCE_REFRESH_PARAMETER);
            }
            if ((accountSummary = this.accountDao.getAccountSummary((PortletRequest)req, start, max, refresh)).isValid()) {
                model.put("accountSummary", accountSummary);
                model.put("inboxUrl", accountSummary.getInboxUrl());
                this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
            } else {
                Throwable cause = accountSummary.getErrorCause();
                if (MailAuthenticationException.class.isAssignableFrom(cause.getClass())) {
                    model.put("errorCode", 401);
                    this.ajaxPortletSupportService.redirectAjaxResponse("ajax/error", model, req, res);
                    this.log.info((Object)("Authentication Failure (username='" + username + "') : " + cause.getMessage()));
                } else {
                    model.put("errorMessage", cause.getMessage());
                    this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
                    this.log.error((Object)"Unanticipated Error", cause);
                }
            }
        }
        catch (MailTimeoutException ex) {
            model.put("errorCode", 504);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/error", model, req, res);
            this.log.error((Object)"Mail Service Timeout", (Throwable)ex);
        }
        catch (Exception ex) {
            model.put("errorMessage", ex.getMessage());
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
            this.log.error((Object)"Unanticipated Error", (Throwable)ex);
        }
    }
}

