/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.util.MessageUtils;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailMessageController {
    private static final String CONTENT_TYPE_TEXT_PREFIX = "text/plain;";
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=true)
    private IEmailAccountService accountDao;
    @Autowired(required=true)
    private AjaxPortletSupportService ajaxPortletSupportService;

    @RequestMapping(params={"action=emailMessage"})
    public void showMessage(ActionRequest req, ActionResponse res, @RequestParam(value="messageNum") int messageNum) {
        try {
            EmailMessage message = this.accountDao.getMessage((PortletRequest)req, messageNum);
            String contentType = message.getContentType();
            if (contentType != null && contentType.startsWith(CONTENT_TYPE_TEXT_PREFIX)) {
                String messageBody = message.getContent().getContentString();
                message.getContent().setContentString(MessageUtils.addClickableUrlsToMessageBody(messageBody));
            }
            HashMap<String, EmailMessage> model = new HashMap<String, EmailMessage>();
            model.put("message", message);
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
        }
        catch (Exception ex) {
            this.log.error((Object)"Error encountered while attempting to retrieve message", (Throwable)ex);
        }
    }

    @RequestMapping(params={"action=deleteMessages"})
    public void deleteMessages(ActionRequest req, ActionResponse res, @RequestParam(value="selectMessage", required=false) long[] uids) {
        try {
            String deletePermitted = req.getPreferences().getValue("allowDelete", "true");
            if (!Boolean.valueOf(deletePermitted).booleanValue()) {
                String msg = "The delete function is not permitted for this portlet";
                throw new RuntimeException(msg);
            }
            if (uids != null && uids.length != 0) {
                this.accountDao.deleteMessages((PortletRequest)req, uids);
            }
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("success", "success");
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete specified messages", e);
        }
    }

    @RequestMapping(params={"action=toggleSeen"})
    public void toggleSeen(ActionRequest req, ActionResponse res, @RequestParam(value="selectMessage", required=false) long[] messages, @RequestParam(value="seenValue") boolean seenValue) {
        try {
            if (messages != null && messages.length != 0) {
                this.accountDao.setSeenFlag((PortletRequest)req, messages, seenValue);
            }
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("success", "success");
            this.ajaxPortletSupportService.redirectAjaxResponse("ajax/json", model, req, res);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete specified messages", e);
        }
    }
}

