/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailSummaryController {
    public static final String WELCOME_TITLE_PREFERENCE = "welcomeTitle";
    public static final String WELCOME_INSTRUCTIONS_PREFERENCE = "welcomeInstructions";
    public static final String DEFAULT_VIEW_PREFERENCE = "defaultView";
    public static final String PAGE_SIZE_PREFERENCE = "pageSize";
    public static final String ALLOW_DELETE_PREFERENCE = "allowDelete";
    public static final String SUPPORTS_TOGGLE_SEEN_KEY = "supportsToggleSeen";
    private static final String SHOW_CONFIG_LINK_KEY = "showConfigLink";
    private static final String DEFAULT_WELCOME_TITLE = "Welcome to Email Preview";
    private static final String DEFAULT_WELCOME_INSTRUCTIONS = "";
    private final Log log = LogFactory.getLog(this.getClass());
    private String adminRoleName = "admin";
    @Autowired(required=true)
    private IServiceBroker serviceBroker;
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    private ILinkServiceRegistry linkServiceRegistry;
    @Resource
    private Map<String, String> jsErrorMessages;

    public void setAdminRoleName(String adminRoleName) {
        this.adminRoleName = adminRoleName;
    }

    @RequestMapping(params={"action=showRollup"})
    public void switchToRollup(ActionRequest req, ActionResponse res) {
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValue(DEFAULT_VIEW_PREFERENCE, View.ROLLUP.getKey());
            prefs.store();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to update defaultView for user " + req.getRemoteUser()), t);
            throw new RuntimeException(t);
        }
    }

    @RequestMapping(params={"action=showPreview"})
    public void switchToPreview(ActionRequest req, ActionResponse res) {
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValue(DEFAULT_VIEW_PREFERENCE, View.PREVIEW.getKey());
            prefs.store();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to update defaultView for user " + req.getRemoteUser()), t);
            throw new RuntimeException(t);
        }
    }

    @RequestMapping
    public ModelAndView chooseView(RenderRequest req, RenderResponse res) throws Exception {
        View showView = null;
        MailStoreConfiguration config = this.serviceBroker.getConfiguration((PortletRequest)req);
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (!authService.isConfigured((PortletRequest)req, config)) {
            showView = View.WELCOME;
        } else if (req.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            showView = View.PREVIEW;
        } else {
            PortletPreferences prefs = req.getPreferences();
            String viewName = prefs.getValue(DEFAULT_VIEW_PREFERENCE, View.ROLLUP.getKey());
            showView = View.getInstance(viewName);
        }
        ModelAndView rslt = showView.show(req, res, this);
        rslt.getModel().put("jsErrorMessages", this.jsErrorMessages);
        rslt.getModel().put("supportsEdit", req.isPortletModeAllowed(PortletMode.EDIT));
        rslt.getModel().put("supportsHelp", req.isPortletModeAllowed(PortletMode.HELP));
        return rslt;
    }

    public static enum View {
        WELCOME("welcome"){

            @Override
            public ModelAndView show(RenderRequest req, RenderResponse res, EmailSummaryController controller) {
                PortletPreferences prefs = req.getPreferences();
                HashMap<String, String> model = new HashMap<String, String>();
                model.put(EmailSummaryController.WELCOME_TITLE_PREFERENCE, prefs.getValue(EmailSummaryController.WELCOME_TITLE_PREFERENCE, EmailSummaryController.DEFAULT_WELCOME_TITLE));
                model.put(EmailSummaryController.WELCOME_INSTRUCTIONS_PREFERENCE, prefs.getValue(EmailSummaryController.WELCOME_INSTRUCTIONS_PREFERENCE, EmailSummaryController.DEFAULT_WELCOME_INSTRUCTIONS));
                return new ModelAndView(this.getKey(), model);
            }
        }
        ,
        ROLLUP("rollup"){
            private final Pattern domainPattern = Pattern.compile("\\.([a-zA-Z0-9]+\\.[a-zA-Z0-9]+)\\z");

            @Override
            public ModelAndView show(RenderRequest req, RenderResponse res, EmailSummaryController controller) {
                HashMap<String, String> model = new HashMap<String, String>();
                MailStoreConfiguration config = controller.serviceBroker.getConfiguration((PortletRequest)req);
                IAuthenticationService authService = controller.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
                String emailAddress = null;
                String mailAccount = authService.getMailAccountName((PortletRequest)req, config);
                String nameSuffix = config.getUsernameSuffix();
                String serverName = config.getHost();
                if (mailAccount.contains("@")) {
                    emailAddress = mailAccount;
                } else if (nameSuffix != null && nameSuffix.length() != 0) {
                    emailAddress = mailAccount + nameSuffix;
                } else {
                    emailAddress = mailAccount;
                    Matcher m = this.domainPattern.matcher(serverName);
                    if (m.find()) {
                        emailAddress = emailAddress + "@" + m.group(1);
                    }
                }
                model.put("emailAddress", emailAddress);
                IEmailLinkService linkService = controller.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
                if (linkService != null) {
                    String inboxUrl = linkService.getInboxUrl(config);
                    model.put("inboxUrl", inboxUrl);
                }
                return new ModelAndView(this.getKey(), model);
            }
        }
        ,
        PREVIEW("preview"){

            @Override
            public ModelAndView show(RenderRequest req, RenderResponse res, EmailSummaryController controller) {
                HashMap<String, Constable> model = new HashMap<String, Constable>();
                PortletPreferences prefs = req.getPreferences();
                int pageSize = Integer.parseInt(prefs.getValue(EmailSummaryController.PAGE_SIZE_PREFERENCE, "10"));
                model.put(EmailSummaryController.PAGE_SIZE_PREFERENCE, Integer.valueOf(pageSize));
                boolean showConfigLink = Boolean.valueOf(prefs.getValue(EmailSummaryController.SHOW_CONFIG_LINK_KEY, "false"));
                if (showConfigLink) {
                    showConfigLink = req.isUserInRole(controller.adminRoleName);
                }
                model.put(EmailSummaryController.SHOW_CONFIG_LINK_KEY, Boolean.valueOf(showConfigLink));
                boolean allowDelete = Boolean.valueOf(prefs.getValue(EmailSummaryController.ALLOW_DELETE_PREFERENCE, "false"));
                model.put(EmailSummaryController.ALLOW_DELETE_PREFERENCE, Boolean.valueOf(allowDelete));
                MailStoreConfiguration config = controller.serviceBroker.getConfiguration((PortletRequest)req);
                model.put("markMessagesAsRead", Boolean.valueOf(config.getMarkMessagesAsRead()));
                model.put(EmailSummaryController.SUPPORTS_TOGGLE_SEEN_KEY, Boolean.valueOf(config.supportsToggleSeen()));
                return new ModelAndView(this.getKey(), model);
            }
        };

        private final String key;

        public static View getInstance(String key) {
            for (View v : View.values()) {
                if (!v.getKey().equals(key)) continue;
                return v;
            }
            throw new RuntimeException("Unrecognized view:  " + key);
        }

        private View(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public abstract ModelAndView show(RenderRequest var1, RenderResponse var2, EmailSummaryController var3);
    }
}

