/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.controller.EmailSummaryController;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class EmailSummaryController {
    public static final String WELCOME_TITLE_PREFERENCE = "welcomeTitle";
    public static final String WELCOME_INSTRUCTIONS_PREFERENCE = "welcomeInstructions";
    public static final String DEFAULT_VIEW_PREFERENCE = "defaultView";
    public static final String PAGE_SIZE_PREFERENCE = "pageSize";
    public static final String ALLOW_DELETE_PREFERENCE = "allowDelete";
    public static final String SUPPORTS_TOGGLE_SEEN_KEY = "supportsToggleSeen";
    private static final String SHOW_CONFIG_LINK_KEY = "showConfigLink";
    private static final String DEFAULT_WELCOME_TITLE = "Welcome to Email Preview";
    private static final String DEFAULT_WELCOME_INSTRUCTIONS = "";
    private final Log log = LogFactory.getLog(this.getClass());
    private String adminRoleName = "admin";
    @Autowired(required=true)
    private IServiceBroker serviceBroker;
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    private ILinkServiceRegistry linkServiceRegistry;
    @Resource
    private Map<String, String> jsErrorMessages;

    public void setAdminRoleName(String adminRoleName) {
        this.adminRoleName = adminRoleName;
    }

    @RequestMapping(params={"action=showRollup"})
    public void switchToRollup(ActionRequest req, ActionResponse res) {
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValue("defaultView", View.ROLLUP.getKey());
            prefs.store();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to update defaultView for user " + req.getRemoteUser()), t);
            throw new RuntimeException(t);
        }
    }

    @RequestMapping(params={"action=showPreview"})
    public void switchToPreview(ActionRequest req, ActionResponse res) {
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValue("defaultView", View.PREVIEW.getKey());
            prefs.store();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to update defaultView for user " + req.getRemoteUser()), t);
            throw new RuntimeException(t);
        }
    }

    @RequestMapping
    public ModelAndView chooseView(RenderRequest req, RenderResponse res) throws Exception {
        View showView = null;
        MailStoreConfiguration config = this.serviceBroker.getConfiguration((PortletRequest)req);
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (!authService.isConfigured((PortletRequest)req, config)) {
            showView = View.WELCOME;
        } else if (req.getWindowState().equals((Object)WindowState.MAXIMIZED)) {
            showView = View.PREVIEW;
        } else {
            PortletPreferences prefs = req.getPreferences();
            String viewName = prefs.getValue("defaultView", View.ROLLUP.getKey());
            showView = View.getInstance((String)viewName);
        }
        ModelAndView rslt = showView.show(req, res, this);
        rslt.getModel().put("jsErrorMessages", this.jsErrorMessages);
        rslt.getModel().put("supportsEdit", req.isPortletModeAllowed(PortletMode.EDIT));
        rslt.getModel().put("supportsHelp", req.isPortletModeAllowed(PortletMode.HELP));
        return rslt;
    }

    static /* synthetic */ IServiceBroker access$100(EmailSummaryController x0) {
        return x0.serviceBroker;
    }

    static /* synthetic */ IAuthenticationServiceRegistry access$200(EmailSummaryController x0) {
        return x0.authServiceRegistry;
    }

    static /* synthetic */ ILinkServiceRegistry access$300(EmailSummaryController x0) {
        return x0.linkServiceRegistry;
    }

    static /* synthetic */ String access$400(EmailSummaryController x0) {
        return x0.adminRoleName;
    }
}

