/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailMessageContent;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.springframework.stereotype.Component;

@Component
public final class DemoAccountService
implements IEmailAccountService {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String ACCOUNT_SUMMARY_KEY = "DemoAccountService.ACCOUNT_SUMMARY_KEY";
    private static final String INBOX_URL = "http://www.jasig.org/";
    private static final int DEFAULT_BATCH_SIZE = 20;
    private String jsonLocation = "/SampleJSON.json";

    public void setJsonLocation(String jsonLocation) {
        this.jsonLocation = jsonLocation;
    }

    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh) {
        PortletSession session = req.getPortletSession();
        AccountSummary rslt = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (rslt == null) {
            List messages = this.getEmailMessages(req);
            rslt = new AccountSummary(INBOX_URL, messages, this.getUnreadMessageCount(messages), messages.size(), start, max, true);
            req.getPortletSession().setAttribute(ACCOUNT_SUMMARY_KEY, (Object)rslt);
        }
        return rslt;
    }

    public EmailMessage getMessage(PortletRequest req, int messageNum) {
        List messages;
        AccountSummary summary = (AccountSummary)req.getPortletSession().getAttribute(ACCOUNT_SUMMARY_KEY);
        if (summary == null) {
            summary = this.getAccountSummary(req, 0, 20, false);
        }
        if ((messages = summary.getMessages()).size() <= messageNum) {
            throw new RuntimeException("No such message:  " + messageNum);
        }
        return (EmailMessage)messages.get(messageNum);
    }

    public boolean deleteMessages(PortletRequest req, long[] uids) {
        List<Long> excluded = Arrays.asList(ArrayUtils.toObject((long[])uids));
        PortletSession session = req.getPortletSession(true);
        AccountSummary summary = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (summary == null) {
            summary = this.getAccountSummary(req, 0, 20, false);
        }
        List messages = summary.getMessages();
        ArrayList<EmailMessage> newList = new ArrayList<EmailMessage>();
        for (EmailMessage m : messages) {
            if (excluded.contains(m.getUid())) continue;
            newList.add(m);
        }
        session.setAttribute(ACCOUNT_SUMMARY_KEY, (Object)new AccountSummary(INBOX_URL, newList, this.getUnreadMessageCount(newList), newList.size(), 0, 20, true));
        return true;
    }

    public boolean setSeenFlag(PortletRequest req, long[] uids, boolean seenValue) {
        List<Long> changed = Arrays.asList(ArrayUtils.toObject((long[])uids));
        PortletSession session = req.getPortletSession(true);
        AccountSummary summary = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (summary == null) {
            summary = this.getAccountSummary(req, 0, 20, false);
        }
        List messages = summary.getMessages();
        ArrayList<EmailMessage> newList = new ArrayList<EmailMessage>();
        for (EmailMessage m : messages) {
            EmailMessage msg = !changed.contains(m.getUid()) ? m : new EmailMessage(newList.size(), m.getUid(), m.getSender(), m.getSubject(), m.getSentDate(), !seenValue, m.isAnswered(), m.isDeleted(), m.isMultipart(), m.getContentType(), m.getContent());
            newList.add(msg);
        }
        session.setAttribute(ACCOUNT_SUMMARY_KEY, (Object)new AccountSummary(INBOX_URL, newList, this.getUnreadMessageCount(newList), newList.size(), 0, 20, true));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EmailMessage> getEmailMessages(PortletRequest req) {
        File jsonFile = new File(this.getClass().getResource(this.jsonLocation).getFile());
        ArrayList<EmailMessage> messages = new ArrayList<EmailMessage>();
        FileInputStream inpt = null;
        try {
            inpt = new FileInputStream(jsonFile);
            JSONArray returnedFiles = JSONArray.fromObject((Object)IOUtils.toString((InputStream)inpt));
            for (int i = 0; i < returnedFiles.size(); ++i) {
                JSONObject msg = returnedFiles.getJSONObject(i);
                long uid = msg.getLong("uid");
                String sender = msg.getString("from");
                String subject = msg.getString("subject");
                Date sentDate = new Date(msg.getLong("sentDate"));
                boolean unread = msg.getBoolean("unread");
                boolean answered = false;
                boolean deleted = false;
                EmailMessageContent content = new EmailMessageContent(msg.getString("body"), true);
                messages.add(new EmailMessage(messages.size(), Long.valueOf(uid), sender, subject, sentDate, unread, answered, deleted, false, "text/plain", content));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load messages collection", (Throwable)e);
        }
        finally {
            try {
                ((InputStream)inpt).close();
            }
            catch (IOException ioe) {
                this.log.error((Object)"Failed to close input stream", (Throwable)ioe);
            }
        }
        return messages;
    }

    private int getUnreadMessageCount(List<EmailMessage> messages) {
        int unreadCount = 0;
        for (EmailMessage email : messages) {
            if (!email.isUnread()) continue;
            ++unreadCount;
        }
        return unreadCount;
    }
}

