/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.javamail;

import java.io.IOException;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.UIDFolder;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.dao.javamail.IJavamailAccountDao;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class JavamailAccountService
implements IEmailAccountService {
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    private IServiceBroker serviceBroker;
    @Autowired
    private IJavamailAccountDao dao;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh) throws EmailPreviewException {
        AccountSummary rslt;
        String username = req.getRemoteUser();
        if (username == null) {
            throw new EmailPreviewException("Anonymous access is not supported");
        }
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (authService == null) {
            String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
            this.log.error((Object)msg);
            throw new EmailPreviewException(msg);
        }
        Authenticator auth = authService.getAuthenticator(req, config);
        String mailAccount = authService.getMailAccountName(req, config);
        if (refresh) {
            this.dao.clearCache(username, mailAccount);
        }
        if ((rslt = this.dao.fetchAccountSummaryFromStore(config, auth, username, mailAccount, start, max)).getMessagesStart() != start || rslt.getMessagesMax() != max) {
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Clearing AccountSummary cache for username '").append(username).append("', mailAccount '").append(mailAccount).append("':  start=[").append(rslt.getMessagesStart()).append(" prev, ").append(start).append(" current] ").append("count=[").append(rslt.getMessagesMax()).append(" prev, ").append(max).append(" current]");
                this.log.debug((Object)msg.toString());
            }
            this.dao.clearCache(username, mailAccount);
            rslt = this.dao.fetchAccountSummaryFromStore(config, auth, username, mailAccount, start, max);
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmailMessage getMessage(PortletRequest req, int messageNum) {
        Folder inbox = null;
        try {
            boolean unread;
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            int mode = config.getMarkMessagesAsRead() ? 2 : 1;
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            inbox = this.dao.getUserInbox(session, config.getInboxFolderName());
            inbox.open(mode);
            Message message = inbox.getMessage(messageNum);
            boolean bl = unread = !message.isSet(Flags.Flag.SEEN);
            if (config.getMarkMessagesAsRead()) {
                message.setFlag(Flags.Flag.SEEN, true);
            }
            EmailMessage emailMessage = this.dao.wrapMessage(message, true, session);
            if (!config.getMarkMessagesAsRead()) {
                emailMessage.setUnread(unread);
            }
            inbox.close(false);
            EmailMessage emailMessage2 = emailMessage;
            return emailMessage2;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while retrieving individual message", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"IO exception while retrieving individual message", (Throwable)e);
        }
        catch (ScanException e) {
            this.log.error((Object)"AntiSamy scanning exception while retrieving individual message", (Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error((Object)"AntiSamy policy exception while retrieving individual message", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessages(PortletRequest req, long[] uids) {
        Folder inbox = null;
        try {
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            inbox = this.dao.getUserInbox(session, config.getInboxFolderName());
            if (!(inbox instanceof UIDFolder)) {
                String msg = "Delete feature is supported only for UIDFolder instances";
                throw new UnsupportedOperationException(msg);
            }
            inbox.open(2);
            Message[] msgs = ((UIDFolder)inbox).getMessagesByUID(uids);
            inbox.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while deleting messages", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(true);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error closing inbox folder", (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSeenFlag(PortletRequest req, long[] uids, boolean value) {
        Folder inbox = null;
        try {
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            inbox = this.dao.getUserInbox(session, config.getInboxFolderName());
            if (!(inbox instanceof UIDFolder)) {
                String msg = "Toggle unread feature is supported only for UIDFolder instances";
                throw new UnsupportedOperationException(msg);
            }
            inbox.open(2);
            Message[] msgs = ((UIDFolder)inbox).getMessagesByUID(uids);
            inbox.setFlags(msgs, new Flags(Flags.Flag.SEEN), value);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while deleting messages", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(true);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error closing inbox folder", (Throwable)e);
                }
            }
        }
        return false;
    }
}

