/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.util.MessageUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailMessageController {
    private static final String CONTENT_TYPE_TEXT_PREFIX = "text/plain;";
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=true)
    private IEmailAccountService accountDao;

    @ResourceMapping(value="emailMessage")
    public ModelAndView showMessage(ResourceRequest req, ResourceResponse res, @RequestParam(value="messageNum") int messageNum) {
        HashMap<String, EmailMessage> model = new HashMap<String, EmailMessage>();
        try {
            EmailMessage message = this.accountDao.getMessage((PortletRequest)req, messageNum);
            String contentType = message.getContentType();
            if (contentType != null && contentType.startsWith(CONTENT_TYPE_TEXT_PREFIX)) {
                String messageBody = message.getContent().getContentString();
                message.getContent().setContentString(MessageUtils.addClickableUrlsToMessageBody(messageBody));
            }
            model.put("message", message);
        }
        catch (Exception ex) {
            this.log.error((Object)"Error encountered while attempting to retrieve message", (Throwable)ex);
        }
        return new ModelAndView("json", model);
    }

    @ResourceMapping(value="deleteMessages")
    public ModelAndView deleteMessages(ResourceRequest req, ResourceResponse res, @RequestParam(value="selectMessage", required=false) long[] uids) {
        HashMap<String, String> model = new HashMap<String, String>();
        try {
            String deletePermitted = req.getPreferences().getValue("allowDelete", "true");
            if (!Boolean.valueOf(deletePermitted).booleanValue()) {
                String msg = "The delete function is not permitted for this portlet";
                throw new RuntimeException(msg);
            }
            if (uids != null && uids.length != 0) {
                this.accountDao.deleteMessages((PortletRequest)req, uids);
            }
            model.put("success", "success");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete specified messages", e);
        }
        return new ModelAndView("json", model);
    }

    @ResourceMapping(value="toggleSeen")
    public ModelAndView toggleSeen(ResourceRequest req, ResourceResponse res, @RequestParam(value="selectMessage", required=false) long[] messages, @RequestParam(value="seenValue") boolean seenValue) {
        HashMap<String, String> model = new HashMap<String, String>();
        try {
            if (messages != null && messages.length != 0) {
                this.accountDao.setSeenFlag((PortletRequest)req, messages, seenValue);
            }
            model.put("success", "success");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update the seen flag for specified messages", e);
        }
        return new ModelAndView("json", model);
    }
}

