/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;
import org.springframework.stereotype.Component;

@Component(value="portletPreferencesCredentialsAuthenticationService")
public class PortletPreferencesCredentialsAuthenticationServiceImpl
implements IAuthenticationService {
    public static final String KEY = "portletPreferences";
    private final List<ConfigurationParameter> userParameters;
    private Map<String, ConfigurationParameter> configParams;

    public PortletPreferencesCredentialsAuthenticationServiceImpl() {
        ArrayList<ConfigurationParameter> params = new ArrayList<ConfigurationParameter>();
        ConfigurationParameter usernameParam = new ConfigurationParameter();
        usernameParam.setKey(MailPreferences.MAIL_ACCOUNT.getKey());
        usernameParam.setLabel("Inbox folder name");
        usernameParam.setEncryptionRequired(true);
        params.add(usernameParam);
        ConfigurationParameter passwordParam = new ConfigurationParameter();
        passwordParam.setKey(MailPreferences.PASSWORD.getKey());
        passwordParam.setLabel("Inbox folder name");
        passwordParam.setEncryptionRequired(true);
        params.add(passwordParam);
        this.userParameters = Collections.unmodifiableList(params);
        HashMap<String, ConfigurationParameter> m = new HashMap<String, ConfigurationParameter>();
        for (ConfigurationParameter param : this.userParameters) {
            m.put(param.getKey(), param);
        }
        this.configParams = Collections.unmodifiableMap(m);
    }

    @Override
    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return this.configParams;
    }

    @Override
    public boolean isConfigured(PortletRequest req, MailStoreConfiguration config) {
        String mailAccount = this.getMailAccountName(req, config);
        String password = config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        return mailAccount != null && password != null;
    }

    @Override
    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        String password = config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        return new SimplePasswordAuthenticator(this.getMailAccountName(request, config), password);
    }

    @Override
    public String getMailAccountName(PortletRequest request, MailStoreConfiguration config) {
        String rslt = config.getAdditionalProperties().get(MailPreferences.MAIL_ACCOUNT.getKey());
        String suffix = config.getUsernameSuffix();
        if (rslt != null && !StringUtils.isBlank((String)suffix)) {
            rslt = rslt.concat(suffix);
        }
        return rslt;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return this.userParameters;
    }
}

