/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.security.IStringEncryptionService;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleServiceBroker
implements IServiceBroker {
    private IAuthenticationServiceRegistry authServiceRegistry;
    private IStringEncryptionService stringEncryptionService;
    protected static final List<String> RESERVED_PROPERTIES = Arrays.asList(MailPreferences.HOST.getKey(), MailPreferences.PORT.getKey(), MailPreferences.INBOX_NAME.getKey(), MailPreferences.PROTOCOL.getKey(), MailPreferences.TIMEOUT.getKey(), MailPreferences.CONNECTION_TIMEOUT.getKey(), MailPreferences.LINK_SERVICE_KEY.getKey(), MailPreferences.AUTHENTICATION_SERVICE_KEY.getKey(), MailPreferences.ALLOWABLE_AUTHENTICATION_SERVICE_KEYS.getKey(), MailPreferences.USERNAME_SUFFIX.getKey(), MailPreferences.MARK_MESSAGES_AS_READ.getKey());

    public MailStoreConfiguration getConfiguration(PortletRequest request) {
        IAuthenticationService authServ;
        PortletPreferences prefs = request.getPreferences();
        MailStoreConfiguration config = new MailStoreConfiguration();
        config.setHost(prefs.getValue(MailPreferences.HOST.getKey(), null));
        config.setInboxFolderName(prefs.getValue(MailPreferences.INBOX_NAME.getKey(), null));
        config.setProtocol(prefs.getValue(MailPreferences.PROTOCOL.getKey(), null));
        config.setLinkServiceKey(prefs.getValue(MailPreferences.LINK_SERVICE_KEY.getKey(), null));
        config.setAuthenticationServiceKey(prefs.getValue(MailPreferences.AUTHENTICATION_SERVICE_KEY.getKey(), null));
        String[] authServiceKeys = prefs.getValues(MailPreferences.ALLOWABLE_AUTHENTICATION_SERVICE_KEYS.getKey(), new String[0]);
        config.setAllowableAuthenticationServiceKeys(Arrays.asList(authServiceKeys));
        config.setUsernameSuffix(prefs.getValue(MailPreferences.USERNAME_SUFFIX.getKey(), null));
        config.setMarkMessagesAsRead(Boolean.valueOf(prefs.getValue(MailPreferences.MARK_MESSAGES_AS_READ.getKey(), "true")).booleanValue());
        try {
            int port = Integer.parseInt(prefs.getValue(MailPreferences.PORT.getKey(), "25"));
            config.setPort(port);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        try {
            int connectionTimeout = Integer.parseInt(prefs.getValue(MailPreferences.CONNECTION_TIMEOUT.getKey(), "-1"));
            config.setConnectionTimeout(connectionTimeout);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        try {
            int timeout = Integer.parseInt(prefs.getValue(MailPreferences.TIMEOUT.getKey(), "-1"));
            config.setTimeout(timeout);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        Map allParams = Collections.emptyMap();
        String authKey = config.getAuthenticationServiceKey();
        IAuthenticationService iAuthenticationService = authServ = authKey != null ? this.authServiceRegistry.getAuthenticationService(authKey) : null;
        if (authServ != null) {
            allParams = authServ.getConfigurationParametersMap();
        }
        Map preferenceMap = prefs.getMap();
        for (Map.Entry entry : preferenceMap.entrySet()) {
            String key = (String)entry.getKey();
            if (RESERVED_PROPERTIES.contains(key) || ((String[])entry.getValue()).length <= 0) continue;
            String value = ((String[])entry.getValue())[0];
            if (key.startsWith("mail.")) {
                config.getJavaMailProperties().put(key, value);
                continue;
            }
            ConfigurationParameter param = (ConfigurationParameter)allParams.get(key);
            if (param != null && param.isEncryptionRequired()) {
                value = this.stringEncryptionService.decrypt(value);
            }
            config.getAdditionalProperties().put(key, value);
        }
        return config;
    }

    public void saveConfiguration(ActionRequest request, MailStoreConfiguration config) {
        PortletPreferences prefs = request.getPreferences();
        try {
            IAuthenticationService authServ;
            HashSet prefNames = new HashSet(prefs.getMap().keySet());
            for (String string : prefNames) {
                if (prefs.isReadOnly(string)) continue;
                prefs.reset(string);
            }
            if (!prefs.isReadOnly(MailPreferences.HOST.getKey())) {
                prefs.setValue(MailPreferences.HOST.getKey(), config.getHost());
            }
            if (!prefs.isReadOnly(MailPreferences.PROTOCOL.getKey())) {
                prefs.setValue(MailPreferences.PROTOCOL.getKey(), config.getProtocol());
            }
            if (!prefs.isReadOnly(MailPreferences.INBOX_NAME.getKey())) {
                prefs.setValue(MailPreferences.INBOX_NAME.getKey(), config.getInboxFolderName());
            }
            if (!prefs.isReadOnly(MailPreferences.PORT.getKey())) {
                prefs.setValue(MailPreferences.PORT.getKey(), String.valueOf(config.getPort()));
            }
            if (!prefs.isReadOnly(MailPreferences.CONNECTION_TIMEOUT.getKey())) {
                prefs.setValue(MailPreferences.CONNECTION_TIMEOUT.getKey(), String.valueOf(config.getConnectionTimeout()));
            }
            if (!prefs.isReadOnly(MailPreferences.TIMEOUT.getKey())) {
                prefs.setValue(MailPreferences.TIMEOUT.getKey(), String.valueOf(config.getTimeout()));
            }
            if (!prefs.isReadOnly(MailPreferences.LINK_SERVICE_KEY.getKey())) {
                prefs.setValue(MailPreferences.LINK_SERVICE_KEY.getKey(), String.valueOf(config.getLinkServiceKey()));
            }
            if (!prefs.isReadOnly(MailPreferences.AUTHENTICATION_SERVICE_KEY.getKey())) {
                prefs.setValue(MailPreferences.AUTHENTICATION_SERVICE_KEY.getKey(), config.getAuthenticationServiceKey());
            }
            if (!prefs.isReadOnly(MailPreferences.MARK_MESSAGES_AS_READ.getKey())) {
                prefs.setValue(MailPreferences.MARK_MESSAGES_AS_READ.getKey(), String.valueOf(config.getMarkMessagesAsRead()));
            }
            if (!prefs.isReadOnly(MailPreferences.ALLOWABLE_AUTHENTICATION_SERVICE_KEYS.getKey())) {
                prefs.setValues(MailPreferences.ALLOWABLE_AUTHENTICATION_SERVICE_KEYS.getKey(), config.getAllowableAuthenticationServiceKeys().toArray(new String[0]));
            }
            if (!prefs.isReadOnly(MailPreferences.USERNAME_SUFFIX.getKey())) {
                prefs.setValue(MailPreferences.USERNAME_SUFFIX.getKey(), config.getUsernameSuffix());
            }
            for (Map.Entry entry : config.getJavaMailProperties().entrySet()) {
                if (prefs.isReadOnly((String)entry.getKey())) continue;
                prefs.setValue((String)entry.getKey(), (String)entry.getValue());
            }
            Map allParams = Collections.emptyMap();
            String string = config.getAuthenticationServiceKey();
            IAuthenticationService iAuthenticationService = authServ = string != null ? this.authServiceRegistry.getAuthenticationService(string) : null;
            if (authServ != null) {
                allParams = authServ.getConfigurationParametersMap();
            }
            for (Map.Entry entry : config.getAdditionalProperties().entrySet()) {
                if (prefs.isReadOnly((String)entry.getKey())) continue;
                String value = (String)entry.getValue();
                ConfigurationParameter param = (ConfigurationParameter)allParams.get(entry.getKey());
                if (param != null && param.isEncryptionRequired()) {
                    value = this.stringEncryptionService.encrypt(value);
                }
                prefs.setValue((String)entry.getKey(), value);
            }
            prefs.store();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to store configuration", e);
        }
    }

    @Autowired(required=true)
    public void setAuthenticationServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @Autowired(required=true)
    public void setStringEncryptionService(IStringEncryptionService stringEncryptionService) {
        this.stringEncryptionService = stringEncryptionService;
    }
}

