/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jasig.portlet.emailpreview.EmailMessage;

public final class AccountSummary {
    private final String inboxUrl;
    private final List<EmailMessage> messages;
    private final int numUnreadMessages;
    private final int numTotalMessages;
    private final int messagesStart;
    private final int messagesMax;
    private final boolean deleteSupported;
    private final Throwable errorCause;

    public AccountSummary(String inboxUrl, List<EmailMessage> messages, int numUnreadMessages, int numTotalMessages, int messagesStart, int messagesMax, boolean deleteSupported) {
        if (messages == null) {
            String msg = "Argument 'messages' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        this.inboxUrl = inboxUrl;
        this.messages = Collections.unmodifiableList(new ArrayList<EmailMessage>(messages));
        this.numUnreadMessages = numUnreadMessages;
        this.numTotalMessages = numTotalMessages;
        this.messagesStart = messagesStart;
        this.messagesMax = messagesMax;
        this.deleteSupported = deleteSupported;
        this.errorCause = null;
    }

    public AccountSummary(Throwable errorCause) {
        if (errorCause == null) {
            String msg = "Argument 'errorCause' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        this.inboxUrl = null;
        this.numUnreadMessages = -1;
        this.numTotalMessages = -1;
        this.messages = null;
        this.messagesStart = -1;
        this.messagesMax = -1;
        this.deleteSupported = false;
        this.errorCause = errorCause;
    }

    public boolean isValid() {
        return this.errorCause == null;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    public String getInboxUrl() {
        return this.inboxUrl;
    }

    public int getUnreadMessageCount() {
        return this.numUnreadMessages;
    }

    public int getTotalMessageCount() {
        return this.numTotalMessages;
    }

    public List<EmailMessage> getMessages() {
        return this.messages;
    }

    public int getMessagesStart() {
        return this.messagesStart;
    }

    public int getMessagesMax() {
        return this.messagesMax;
    }

    public boolean isDeleteSupported() {
        return this.deleteSupported;
    }
}

