/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.security;

import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.security.IStringEncryptionService;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;

public class JasyptPBEStringEncryptionServiceImpl
implements IStringEncryptionService {
    PBEStringEncryptor encryptor = null;

    public void setStringEncryptor(PBEStringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public String encrypt(String plaintext) {
        try {
            return this.encryptor.encrypt(plaintext);
        }
        catch (EncryptionInitializationException e) {
            throw new EmailPreviewException("Encryption error. Verify an encryption password is configured in the email preview portlet's stringEncryptionService bean in applicationContent.xml", e);
        }
    }

    @Override
    public String decrypt(String cryptotet) {
        try {
            return this.encryptor.decrypt(cryptotet);
        }
        catch (EncryptionInitializationException e) {
            throw new EmailPreviewException("Decryption error. Was encryption password changed in the email preview portlet's stringEncryptionService bean in applicationContent.xml?", e);
        }
    }
}

