/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationServiceRegistryImpl
implements IAuthenticationServiceRegistry {
    private Map<String, IAuthenticationService> serviceMap = new HashMap();

    @Resource(name="authServices")
    @Required
    public void setServices(Collection<IAuthenticationService> services) {
        this.serviceMap.clear();
        for (IAuthenticationService service : services) {
            this.registerService(service);
        }
    }

    public IAuthenticationService getAuthenticationService(String key) {
        return (IAuthenticationService)this.serviceMap.get(key);
    }

    public Collection<IAuthenticationService> getServices() {
        return this.serviceMap.values();
    }

    public void registerService(IAuthenticationService authService) {
        this.serviceMap.put(authService.getKey(), authService);
    }
}

