/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.io.IOException;
import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.jasig.portlet.emailpreview.exception.MailTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EmailAccountSummaryController {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=true)
    private IEmailAccountService accountDao;
    public static final String FORCE_REFRESH_PARAMETER = "forceRefresh";
    public static final String KEY_ACCOUNT_SUMMARY = "accountSummary";
    public static final String KEY_INBOX_URL = "inboxUrl";
    public static final String KEY_ERROR = "error";
    public static final String KEY_EMAIL_QUOTA_LIMIT = "emailQuotaLimit";
    public static final String KEY_EMAIL_QUOTA_USAGE = "emailQuotaUsage";

    @ResourceMapping(value="accountSummary")
    public ModelAndView getAccountSummary(ResourceRequest req, ResourceResponse res, @RequestParam(value="pageStart") int start, @RequestParam(value="numberOfMessages") int max) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String username = req.getRemoteUser();
        try {
            AccountSummary accountSummary;
            boolean refresh = Boolean.valueOf(req.getParameter(FORCE_REFRESH_PARAMETER));
            if (req.getPortletSession().getAttribute(FORCE_REFRESH_PARAMETER) != null) {
                refresh = true;
                req.getPortletSession().removeAttribute(FORCE_REFRESH_PARAMETER);
            }
            if ((accountSummary = this.accountDao.getAccountSummary((PortletRequest)req, start, max, refresh)).isValid()) {
                model.put(KEY_ACCOUNT_SUMMARY, accountSummary);
                model.put(KEY_INBOX_URL, accountSummary.getInboxUrl());
                if (accountSummary.getQuota() == null) {
                    model.put(KEY_EMAIL_QUOTA_USAGE, "-1");
                } else {
                    model.put(KEY_EMAIL_QUOTA_USAGE, accountSummary.getQuota().getUsageAsPercentage());
                    model.put(KEY_EMAIL_QUOTA_LIMIT, accountSummary.getQuota().getLimitAsString());
                }
            } else {
                Throwable cause = accountSummary.getErrorCause();
                if (MailAuthenticationException.class.isAssignableFrom(cause.getClass())) {
                    this.log.info((Object)("Authentication Failure (username='" + username + "') : " + cause.getMessage()));
                    res.setProperty("portlet.http-status-code", Integer.toString(401));
                    model.put(KEY_ERROR, "Not authorized");
                } else {
                    this.log.error((Object)"Unanticipated Error", cause);
                    res.setProperty("portlet.http-status-code", Integer.toString(500));
                    model.put(KEY_ERROR, "Unanticipated Error");
                }
            }
        }
        catch (MailTimeoutException ex) {
            this.log.error((Object)"Mail Service Timeout", (Throwable)ex);
            res.setProperty("portlet.http-status-code", Integer.toString(504));
            model.put(KEY_ERROR, "Mail Service Timeout");
        }
        catch (Exception ex) {
            this.log.error((Object)"Unanticipated Error", (Throwable)ex);
            res.setProperty("portlet.http-status-code", Integer.toString(500));
            model.put(KEY_ERROR, "ex.getMessage()");
        }
        return new ModelAndView("json", model);
    }
}

