/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.demo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailMessageContent;
import org.jasig.portlet.emailpreview.EmailQuota;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DemoAccountService
implements IEmailAccountService {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String ACCOUNT_SUMMARY_KEY = "DemoAccountService.ACCOUNT_SUMMARY_KEY";
    private static final String INBOX_URL = "http://www.jasig.org/";
    private static final int DEFAULT_BATCH_SIZE = 20;
    private static EmailQuota quota = new EmailQuota(10561140L, 239702L);
    private String jsonLocation = "/SampleJSON.json";
    @Autowired(required=true)
    private IServiceBroker serviceBroker;

    public void setJsonLocation(String jsonLocation) {
        this.jsonLocation = jsonLocation;
    }

    @Override
    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh) {
        PortletSession session = req.getPortletSession();
        AccountSummary rslt = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (rslt == null) {
            List<EmailMessage> messages = this.getEmailMessages(req);
            rslt = new AccountSummary(INBOX_URL, messages, this.getUnreadMessageCount(messages), messages.size(), start, max, true, quota);
            req.getPortletSession().setAttribute(ACCOUNT_SUMMARY_KEY, (Object)rslt);
        }
        return rslt;
    }

    @Override
    public EmailMessage getMessage(PortletRequest req, int messageNum) {
        PortletSession session = req.getPortletSession();
        AccountSummary summary = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (summary == null) {
            summary = this.getAccountSummary(req, 0, 20, false);
        }
        EmailMessage rslt = null;
        List<EmailMessage> messages = summary.getMessages();
        for (EmailMessage m : messages) {
            if (m.getMessageNumber() != messageNum) continue;
            rslt = m;
            break;
        }
        if (rslt == null) {
            throw new RuntimeException("No such message:  " + messageNum);
        }
        if (this.serviceBroker.getConfiguration(req).getMarkMessagesAsRead()) {
            ArrayList<EmailMessage> newList = new ArrayList<EmailMessage>();
            for (EmailMessage m : messages) {
                EmailMessage msg = !m.equals(rslt) ? m : new EmailMessage(m.getMessageNumber(), m.getUid(), m.getSender(), m.getSubject(), m.getSentDate(), false, m.isAnswered(), m.isDeleted(), m.isMultipart(), m.getContentType(), m.getContent());
                newList.add(msg);
            }
            session.setAttribute(ACCOUNT_SUMMARY_KEY, (Object)new AccountSummary(INBOX_URL, newList, this.getUnreadMessageCount(newList), newList.size(), 0, 20, true, quota));
        }
        return rslt;
    }

    @Override
    public boolean deleteMessages(PortletRequest req, long[] uids) {
        List<Long> excluded = Arrays.asList(ArrayUtils.toObject((long[])uids));
        PortletSession session = req.getPortletSession(true);
        AccountSummary summary = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (summary == null) {
            summary = this.getAccountSummary(req, 0, 20, false);
        }
        List<EmailMessage> messages = summary.getMessages();
        ArrayList<EmailMessage> newList = new ArrayList<EmailMessage>();
        for (EmailMessage m : messages) {
            if (excluded.contains(m.getUid())) continue;
            newList.add(m);
        }
        session.setAttribute(ACCOUNT_SUMMARY_KEY, (Object)new AccountSummary(INBOX_URL, newList, this.getUnreadMessageCount(newList), newList.size(), 0, 20, true, quota));
        return true;
    }

    @Override
    public boolean setSeenFlag(PortletRequest req, long[] uids, boolean seenValue) {
        List<Long> changed = Arrays.asList(ArrayUtils.toObject((long[])uids));
        PortletSession session = req.getPortletSession(true);
        AccountSummary summary = (AccountSummary)session.getAttribute(ACCOUNT_SUMMARY_KEY);
        if (summary == null) {
            summary = this.getAccountSummary(req, 0, 20, false);
        }
        List<EmailMessage> messages = summary.getMessages();
        ArrayList<EmailMessage> newList = new ArrayList<EmailMessage>();
        for (EmailMessage m : messages) {
            EmailMessage msg = !changed.contains(m.getUid()) ? m : new EmailMessage(m.getMessageNumber(), m.getUid(), m.getSender(), m.getSubject(), m.getSentDate(), !seenValue, m.isAnswered(), m.isDeleted(), m.isMultipart(), m.getContentType(), m.getContent());
            newList.add(msg);
        }
        session.setAttribute(ACCOUNT_SUMMARY_KEY, (Object)new AccountSummary(INBOX_URL, newList, this.getUnreadMessageCount(newList), newList.size(), 0, 20, true, quota));
        return true;
    }

    private List<EmailMessage> getEmailMessages(PortletRequest req) {
        File jsonFile = new File(this.getClass().getResource(this.jsonLocation).getFile());
        ArrayList<EmailMessage> messages = new ArrayList<EmailMessage>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayNode json = (ArrayNode)mapper.readValue(jsonFile, ArrayNode.class);
            for (JsonNode msg : json) {
                long uid = msg.path("uid").getLongValue();
                String sender = msg.path("from").getTextValue();
                String subject = msg.path("subject").getTextValue();
                Date sentDate = new Date(msg.path("sentDate").getLongValue());
                boolean unread = msg.path("unread").getBooleanValue();
                boolean answered = false;
                boolean deleted = false;
                EmailMessageContent content = new EmailMessageContent(msg.path("body").getTextValue(), true);
                messages.add(new EmailMessage(messages.size(), uid, sender, subject, sentDate, unread, answered, deleted, false, "text/plain", content));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load messages collection", (Throwable)e);
        }
        return messages;
    }

    private int getUnreadMessageCount(List<EmailMessage> messages) {
        int unreadCount = 0;
        for (EmailMessage email : messages) {
            if (!email.isUnread()) continue;
            ++unreadCount;
        }
        return unreadCount;
    }
}

