/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.javamail;

import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.KeyGenerator;
import com.googlecode.ehcache.annotations.PartialCacheKey;
import com.googlecode.ehcache.annotations.Property;
import com.googlecode.ehcache.annotations.TriggersRemove;
import com.sun.mail.imap.IMAPFolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Quota;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailMessageContent;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.EmailQuota;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.javamail.IJavamailAccountDao;
import org.jasig.portlet.emailpreview.exception.MailAuthenticationException;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public final class JavamailAccountDaoImpl
implements IJavamailAccountDao,
InitializingBean,
ApplicationContextAware {
    private static final String CONTENT_TYPE_ATTACHMENTS_PATTERN = "multipart/mixed;";
    private static final String INTERNET_ADDRESS_TYPE = "rfc822";
    @Autowired(required=true)
    private ILinkServiceRegistry linkServiceRegistry;
    private boolean debug = false;
    private String filePath = "classpath:antisamy.xml";
    private ApplicationContext ctx;
    private Policy policy;
    private final Log log = LogFactory.getLog(this.getClass());

    public void setSecurityFile(String path) {
        this.filePath = path;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public void afterPropertiesSet() throws Exception {
        InputStream stream = this.ctx.getResource(this.filePath).getInputStream();
        this.policy = Policy.getInstance((InputStream)stream);
    }

    @Override
    @TriggersRemove(cacheName={"inboxCache"}, keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator", properties={@Property(name="includeMethod", value="false")}))
    public void clearCache(String username, String mailAccount) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Removing cached AccountSummary for [mailAccount=").append(mailAccount).append(", username=").append(username).append("]");
            this.log.debug((Object)msg.toString());
        }
    }

    @Override
    @Cacheable(cacheName="inboxCache", selfPopulating=true, keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator", properties={@Property(name="includeMethod", value="false")}))
    public AccountSummary fetchAccountSummaryFromStore(MailStoreConfiguration config, Authenticator auth, @PartialCacheKey String username, @PartialCacheKey String mailAccount, int start, int max) throws EmailPreviewException {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating new AccountSummary for [mailAccount=").append(mailAccount).append(", username=").append(username).append(", start=").append(start).append(", max=").append(max).append("]");
            this.log.debug((Object)msg.toString());
        }
        Folder inbox = null;
        try {
            Session session = this.openMailSession(config, auth);
            inbox = this.getUserInbox(session, config.getInboxFolderName());
            inbox.open(1);
            long startTime = System.currentTimeMillis();
            List<EmailMessage> messages = this.getEmailMessages(inbox, start, max, session);
            if (this.log.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                int messagesToDisplayCount = messages.size();
                this.log.debug((Object)("Finished looking up email messages. Inbox size: " + inbox.getMessageCount() + " Unread message count: " + inbox.getUnreadMessageCount() + " Total elapsed time: " + elapsedTime + "ms " + " Time per message in inbox: " + (inbox.getMessageCount() == 0 ? 0L : elapsedTime / (long)inbox.getMessageCount()) + "ms" + " Time per displayed message: " + (messagesToDisplayCount == 0 ? 0L : elapsedTime / (long)messagesToDisplayCount) + "ms"));
            }
            IEmailLinkService linkService = this.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
            String inboxUrl = null;
            if (linkService != null) {
                inboxUrl = linkService.getInboxUrl(config);
            }
            AccountSummary rslt = new AccountSummary(inboxUrl, messages, inbox.getUnreadMessageCount(), inbox.getMessageCount(), start, max, this.isDeleteSupported(inbox), this.getQuota(inbox));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Successfully retrieved email AccountSummary");
            }
            AccountSummary accountSummary = rslt;
            return accountSummary;
        }
        catch (MailAuthenticationException mae) {
            AccountSummary accountSummary = new AccountSummary(mae);
            return accountSummary;
        }
        catch (MessagingException me) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)me);
            throw new EmailPreviewException(me);
        }
        catch (IOException e) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException(e);
        }
        catch (ScanException e) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException(e);
        }
        catch (PolicyException e) {
            this.log.error((Object)"Exception encountered while retrieving account info", (Throwable)e);
            throw new EmailPreviewException(e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail store connection");
                }
            }
        }
    }

    @Override
    public Session openMailSession(MailStoreConfiguration config, Authenticator auth) {
        int timeout;
        if (config == null) {
            String msg = "Argument 'config' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (auth == null) {
            String msg = "Argument 'auth' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        Properties mailProperties = new Properties();
        mailProperties.put("mail.store.protocol", config.getProtocol());
        mailProperties.put("mail.host", config.getHost());
        mailProperties.put("mail.port", (Object)config.getPort());
        mailProperties.put("mail.debug", this.debug ? "true" : "false");
        String protocolPropertyPrefix = "mail." + config.getProtocol() + ".";
        int connectionTimeout = config.getConnectionTimeout();
        if (connectionTimeout >= 0) {
            mailProperties.put(protocolPropertyPrefix + "connectiontimeout", (Object)connectionTimeout);
        }
        if ((timeout = config.getTimeout()) >= 0) {
            mailProperties.put(protocolPropertyPrefix + "timeout", (Object)timeout);
        }
        for (Map.Entry<String, String> property : config.getJavaMailProperties().entrySet()) {
            mailProperties.put(property.getKey(), property.getValue());
        }
        return Session.getInstance((Properties)mailProperties, (Authenticator)auth);
    }

    @Override
    public Folder getUserInbox(Session session, String folderName) throws MessagingException {
        if (session == null) {
            String msg = "Argument 'session' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        try {
            Store store = session.getStore();
            store.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Mail store connection established");
            }
            Folder root = store.getDefaultFolder();
            Folder inboxFolder = root.getFolder(folderName);
            return inboxFolder;
        }
        catch (AuthenticationFailedException e) {
            throw new MailAuthenticationException(e);
        }
    }

    @Override
    public EmailMessage wrapMessage(Message msg, boolean populateContent, Session session) throws MessagingException, IOException, ScanException, PolicyException {
        String subject = msg.getSubject();
        if (!StringUtils.isBlank((String)subject)) {
            AntiSamy as = new AntiSamy();
            CleanResults cr = as.scan(subject, this.policy);
            subject = cr.getCleanHTML();
        }
        EmailMessageContent msgContent = null;
        if (populateContent) {
            try {
                msgContent = this.getMessageContent(msg.getContent(), msg.getContentType());
            }
            catch (MessagingException me) {
                this.log.debug((Object)"Difficulty reading a message (digitally signed?). Attempting workaround...");
                try {
                    MimeMessage mm = (MimeMessage)msg;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    mm.writeTo((OutputStream)bos);
                    bos.close();
                    SharedByteArrayInputStream bis = new SharedByteArrayInputStream(bos.toByteArray());
                    MimeMessage copy = new MimeMessage(session, (InputStream)bis);
                    bis.close();
                    msgContent = this.getMessageContent(copy.getContent(), copy.getContentType());
                }
                catch (Throwable t) {
                    this.log.error((Object)"Failed to read message body", t);
                    msgContent = new EmailMessageContent("UNABLE TO READ MESSAGE BODY: " + t.getMessage(), false);
                }
            }
            String content = msgContent.getContentString();
            if (!StringUtils.isBlank((String)content)) {
                AntiSamy as = new AntiSamy();
                CleanResults cr = as.scan(content, this.policy);
                content = cr.getCleanHTML();
            }
            msgContent.setContentString(content);
        }
        int messageNumber = msg.getMessageNumber();
        Long uid = null;
        if (msg.getFolder() instanceof UIDFolder) {
            uid = ((UIDFolder)msg.getFolder()).getUID(msg);
        }
        Address[] addr = msg.getFrom();
        String sender = null;
        if (addr != null && addr.length != 0) {
            Address a = addr[0];
            if (INTERNET_ADDRESS_TYPE.equals(a.getType())) {
                InternetAddress inet = (InternetAddress)a;
                sender = inet.toUnicodeString();
            } else {
                sender = a.toString();
            }
        }
        Date sentDate = msg.getSentDate();
        boolean unread = !msg.isSet(Flags.Flag.SEEN);
        boolean answered = msg.isSet(Flags.Flag.ANSWERED);
        boolean deleted = msg.isSet(Flags.Flag.DELETED);
        boolean multipart = false;
        String contentType = null;
        try {
            multipart = msg.getContentType().toLowerCase().startsWith(CONTENT_TYPE_ATTACHMENTS_PATTERN);
            contentType = msg.getContentType();
        }
        catch (MessagingException me) {
            this.log.debug((Object)"Message content unabailable (digitally signed?);  message will appear in the preview table correctly, but the body will not be viewable");
            this.log.trace((Object)me.getMessage(), (Throwable)me);
        }
        return new EmailMessage(messageNumber, uid, sender, subject, sentDate, unread, answered, deleted, multipart, contentType, msgContent);
    }

    private List<EmailMessage> getEmailMessages(Folder mailFolder, int pageStart, int messageCount, Session session) throws MessagingException, IOException, ScanException, PolicyException {
        int totalMessageCount = mailFolder.getMessageCount();
        int start = Math.max(1, totalMessageCount - pageStart - (messageCount - 1));
        int end = Math.max(totalMessageCount - pageStart, 1);
        Message[] messages = totalMessageCount != 0 ? mailFolder.getMessages(start, end) : new Message[]{};
        long startTime = System.currentTimeMillis();
        FetchProfile profile = new FetchProfile();
        profile.add(FetchProfile.Item.ENVELOPE);
        profile.add(FetchProfile.Item.FLAGS);
        profile.add(FetchProfile.Item.CONTENT_INFO);
        mailFolder.fetch(messages, profile);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Time elapsed while fetching message headers:" + (System.currentTimeMillis() - startTime)));
        }
        LinkedList<EmailMessage> emails = new LinkedList<EmailMessage>();
        for (Message currentMessage : messages) {
            EmailMessage emailMessage = this.wrapMessage(currentMessage, false, session);
            emails.add(emailMessage);
        }
        Collections.reverse(emails);
        return emails;
    }

    private EmailMessageContent getMessageContent(Object content, String mimeType) throws IOException, MessagingException {
        if (content instanceof String) {
            return new EmailMessageContent((String)content, this.isHtml(mimeType));
        }
        if (content instanceof MimeMultipart) {
            Multipart m = (Multipart)content;
            int parts = m.getCount();
            for (int i = parts - 1; i >= 0; --i) {
                EmailMessageContent result = null;
                BodyPart part = m.getBodyPart(i);
                Object partContent = part.getContent();
                String contentType = part.getContentType();
                boolean isHtml = this.isHtml(contentType);
                this.log.debug((Object)("Examining Multipart " + i + " with type " + contentType + " and class " + partContent.getClass()));
                if (partContent instanceof String) {
                    result = new EmailMessageContent((String)partContent, isHtml);
                } else if (partContent instanceof InputStream && contentType.startsWith("text/html")) {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)((InputStream)partContent), (Writer)writer);
                    result = new EmailMessageContent(writer.toString(), isHtml);
                } else if (partContent instanceof MimeMultipart) {
                    result = this.getMessageContent(partContent, contentType);
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private boolean isHtml(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return (mimeType = mimeType.trim().toLowerCase()).contains("text/html");
    }

    private boolean isDeleteSupported(Folder f) {
        return f instanceof UIDFolder;
    }

    private EmailQuota getQuota(Folder folder) {
        if (!(folder instanceof IMAPFolder)) {
            return null;
        }
        try {
            if (folder.exists() && folder.getMessageCount() > 0) {
                Quota[] quotas;
                for (Quota quota : quotas = ((IMAPFolder)folder).getQuota()) {
                    for (Quota.Resource resource : quota.resources) {
                        if (!resource.name.equals("STORAGE")) continue;
                        return new EmailQuota(resource.limit, resource.usage);
                    }
                }
            }
        }
        catch (MessagingException e) {
            this.log.error((Object)"Failed to connect or get quota for mail user ");
        }
        return null;
    }
}

