/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;

public class CachedPasswordAuthenticationService
implements IAuthenticationService {
    private static final String KEY = "cachedPassword";
    public static final String USERNAME_ATTRIBUTE = "user.login.id";
    public static final String PASSWORD_ATTRIBUTE = "password";
    private Map<String, ConfigurationParameter> configParams;

    public CachedPasswordAuthenticationService() {
        HashMap<String, ConfigurationParameter> m = new HashMap<String, ConfigurationParameter>();
        for (ConfigurationParameter param : this.getAdminConfigurationParameters()) {
            m.put(param.getKey(), param);
        }
        for (ConfigurationParameter param : this.getUserConfigurationParameters()) {
            m.put(param.getKey(), param);
        }
        this.configParams = Collections.unmodifiableMap(m);
    }

    @Override
    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return this.configParams;
    }

    @Override
    public boolean isConfigured(PortletRequest req, MailStoreConfiguration config) {
        String mailAccount = this.getMailAccountName(req, config);
        String password = this.getPassword(req);
        return mailAccount != null && password != null;
    }

    @Override
    public Authenticator getAuthenticator(PortletRequest req, MailStoreConfiguration config) {
        return new SimplePasswordAuthenticator(this.getMailAccountName(req, config), this.getPassword(req));
    }

    @Override
    public String getMailAccountName(PortletRequest request, MailStoreConfiguration config) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String rslt = (String)userInfo.get(USERNAME_ATTRIBUTE);
        String usernameSuffix = config.getUsernameSuffix();
        if (rslt != null && !StringUtils.isBlank((String)usernameSuffix)) {
            rslt = rslt.concat(usernameSuffix);
        }
        return rslt;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return Collections.emptyList();
    }

    @Override
    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return Collections.emptyList();
    }

    private String getPassword(PortletRequest req) {
        Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
        return (String)userInfo.get(PASSWORD_ATTRIBUTE);
    }
}

