/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.mvc.Attribute;
import org.jasig.portlet.emailpreview.mvc.MailStoreConfigurationForm;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"CONFIG"})
public class MailStoreConfigurationController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IServiceBroker serviceBroker;
    private List<String> protocols;
    private ILinkServiceRegistry linkServiceRegistry;
    private IAuthenticationServiceRegistry authServiceRegistry;

    @Autowired(required=true)
    public void setServiceBroker(IServiceBroker serviceBroker) {
        this.serviceBroker = serviceBroker;
    }

    @Resource(name="protocols")
    @Required
    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @Autowired(required=true)
    public void setLinkServiceRegistry(ILinkServiceRegistry linkServiceRegistry) {
        this.linkServiceRegistry = linkServiceRegistry;
    }

    @Autowired(required=true)
    public void setAuthServiceRegistry(IAuthenticationServiceRegistry authServiceRegistry) {
        this.authServiceRegistry = authServiceRegistry;
    }

    @RequestMapping
    public String getAccountFormView() {
        return "config";
    }

    @RequestMapping(params={"action=updateConfiguration"})
    public void saveAccountConfiguration(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") MailStoreConfigurationForm form, @RequestParam(value="save", required=false) String save) throws PortletModeException {
        if (StringUtils.isNotBlank((String)save)) {
            MailStoreConfiguration config = new MailStoreConfiguration();
            config.setHost(form.getHost());
            config.setPort(form.getPort());
            config.setProtocol(form.getProtocol());
            config.setInboxFolderName(form.getInboxFolderName());
            List allowableAuthKeys = form.getAllowableAuthenticationServiceKeys();
            String authService = allowableAuthKeys.size() != 0 ? (String)allowableAuthKeys.get(0) : null;
            config.setAuthenticationServiceKey(authService);
            config.setAllowableAuthenticationServiceKeys(allowableAuthKeys);
            config.setUsernameSuffix(form.getUsernameSuffix());
            config.setLinkServiceKey(form.getLinkServiceKey());
            config.setConnectionTimeout(form.getConnectionTimeout());
            config.setTimeout(form.getTimeout());
            String allowContent = request.getParameter(MailPreferences.ALLOW_RENDERING_EMAIL_CONTENT.getKey());
            if (StringUtils.isNotEmpty((String)allowContent)) {
                config.setAllowRenderingEmailContent(Boolean.valueOf(allowContent));
            } else {
                config.setAllowRenderingEmailContent(Boolean.valueOf(false));
            }
            config.setMarkMessagesAsRead(form.getMarkMessagesAsRead());
            for (Map.Entry entry : form.getJavaMailProperties().entrySet()) {
                config.getJavaMailProperties().put(entry.getKey(), ((Attribute)entry.getValue()).getValue());
            }
            for (Map.Entry entry : form.getAdditionalProperties().entrySet()) {
                config.getAdditionalProperties().put(entry.getKey(), ((Attribute)entry.getValue()).getValue());
            }
            this.log.debug((Object)("Saving new mail store configuration: {" + config.toString() + "}"));
            this.serviceBroker.saveConfiguration(request, config);
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    @ModelAttribute(value="form")
    public MailStoreConfigurationForm getConfigurationForm(PortletRequest req) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        return MailStoreConfigurationForm.create((MailStoreConfiguration)config, (PortletRequest)req);
    }

    @ModelAttribute(value="authServices")
    public List<IAuthenticationService> getAvailableAuthServices() {
        return new ArrayList<IAuthenticationService>(this.authServiceRegistry.getServices());
    }

    @ModelAttribute(value="serviceParameters")
    public Map<String, List<ConfigurationParameter>> getServiceParameters(PortletRequest request) {
        HashMap<String, List<ConfigurationParameter>> parameters = new HashMap<String, List<ConfigurationParameter>>();
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(request);
        IEmailLinkService linkService = this.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
        if (linkService != null) {
            parameters.put("linkParameters", linkService.getAdminConfigurationParameters());
        }
        return parameters;
    }

    @ModelAttribute(value="protocols")
    public List<String> getProtocols() {
        return this.protocols;
    }

    @ModelAttribute(value="linkServices")
    public Collection<IEmailLinkService> getLinkServices() {
        return this.linkServiceRegistry.getServices();
    }

    @ModelAttribute(value="authServices")
    public Collection<IAuthenticationService> getAuthServices() {
        return this.authServiceRegistry.getServices();
    }

    @ResourceMapping(value="parameters")
    public ModelAndView getParameters(ResourceRequest req, ResourceResponse res, @RequestParam(value="linkService") String linkServiceKey, @RequestParam(value="authService") String authServiceKey) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            IEmailLinkService linkService;
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(authServiceKey);
            if (authService != null) {
                List authParams = authService.getAdminConfigurationParameters();
                model.put("authParams", authParams);
            }
            if ((linkService = this.linkServiceRegistry.getEmailLinkService(linkServiceKey)) != null) {
                List linkParams = linkService.getAdminConfigurationParameters();
                model.put("linkParams", linkParams);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Error encountered attempting to retrieve parameter definitions", (Throwable)ex);
            res.setProperty("portlet.http-status-code", Integer.toString(500));
            model.put("error", "Error encountered attempting to retrieve parameter definitions");
        }
        return new ModelAndView("json", model);
    }
}

