/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jasig.portlet.emailpreview.EmailMessageContent;

public class EmailMessage {
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"h:mm a MMM d, yyyy");
    private final int messageNumber;
    private final String uid;
    private final String sender;
    private final String subject;
    private final Date sentDate;
    private boolean unread;
    private final boolean answered;
    private final boolean deleted;
    private boolean multipart;
    private String contentType;
    private final EmailMessageContent content;
    private final String allRecipients;

    public EmailMessage(int messageNumber, String uid, String sender, String subject, Date sentDate, boolean unread, boolean answered, boolean deleted, boolean multipart, String contentType, EmailMessageContent content, String allRecipients) {
        this.messageNumber = messageNumber;
        this.uid = uid;
        this.sender = sender;
        this.subject = subject;
        this.sentDate = sentDate;
        this.unread = unread;
        this.answered = answered;
        this.deleted = deleted;
        this.multipart = multipart;
        this.contentType = contentType;
        this.content = content;
        this.allRecipients = allRecipients;
    }

    public EmailMessage(int messageNumber, String uid, String sender, String subject, Date sentDate, boolean unread, boolean answered, boolean deleted, boolean multipart, String contentType, EmailMessageContent content) {
        this(messageNumber, uid, sender, subject, sentDate, unread, answered, deleted, multipart, contentType, content, null);
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public String getUid() {
        return this.uid;
    }

    public String getMessageId() {
        return StringUtils.isNotBlank((String)this.uid) ? this.uid : new Integer(this.messageNumber).toString();
    }

    public Date getSentDate() {
        return this.sentDate != null ? new Date(this.sentDate.getTime()) : null;
    }

    public String getSentDateString() {
        return this.sentDate != null ? DATE_FORMAT.format(this.sentDate) : "";
    }

    public String getSender() {
        return this.sender;
    }

    public String getSenderName() {
        return this.getSender().split("\\s*<")[0];
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean isUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getContentType() {
        return this.contentType;
    }

    public EmailMessageContent getContent() {
        return this.content;
    }

    public String getAllRecipients() {
        return this.allRecipients;
    }
}

