/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import java.io.IOException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jasig.portlet.emailpreview.dao.exchange.JCIFSEngine;

public class NtlmAuthHttpClient
extends DefaultHttpClient {
    public NtlmAuthHttpClient() {
        this.setup();
    }

    public NtlmAuthHttpClient(ClientConnectionManager conman) {
        super(conman);
        this.setup();
    }

    public NtlmAuthHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
        this.setup();
    }

    public NtlmAuthHttpClient(HttpParams params) {
        super(params);
        this.setup();
    }

    private void setup() {
        this.addRequestInterceptor(new RemoveSoapHeadersInterceptor(), 0);
        NTLMSchemeFactory fac = new NTLMSchemeFactory();
        BasicSchemeFactory bfac = new BasicSchemeFactory();
        this.getAuthSchemes().register("Basic", (AuthSchemeFactory)bfac);
        this.getAuthSchemes().register("NTLM", (AuthSchemeFactory)fac);
        this.getAuthSchemes().register("negotiate", (AuthSchemeFactory)fac);
    }

    private static final class NTLMSchemeFactory
    implements AuthSchemeFactory {
        private NTLMSchemeFactory() {
        }

        public AuthScheme newInstance(HttpParams params) {
            return new NTLMScheme((NTLMEngine)new JCIFSEngine());
        }
    }

    private static final class RemoveSoapHeadersInterceptor
    implements HttpRequestInterceptor {
        private RemoveSoapHeadersInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (request instanceof HttpEntityEnclosingRequest) {
                if (request.containsHeader("Transfer-Encoding")) {
                    request.removeHeaders("Transfer-Encoding");
                }
                if (request.containsHeader("Content-Length")) {
                    request.removeHeaders("Content-Length");
                }
            }
        }
    }
}

