/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.javamail;

import java.io.IOException;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.dao.javamail.IJavamailAccountDao;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class JavamailAccountService
implements IEmailAccountService {
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    private IServiceBroker serviceBroker;
    @Autowired
    private IJavamailAccountDao dao;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh, String folder) throws EmailPreviewException {
        AccountSummary rslt;
        String username = req.getRemoteUser();
        if (username == null) {
            throw new EmailPreviewException("Anonymous access is not supported");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Requesting account summary for user " + username + " folder " + folder + ", start=" + start + " max=" + max));
        }
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        config.setInboxFolderName(folder);
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (authService == null) {
            String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
            this.log.error((Object)msg);
            throw new EmailPreviewException(msg);
        }
        Authenticator auth = authService.getAuthenticator(req, config);
        String mailAccount = authService.getMailAccountName(req, config);
        if (refresh) {
            this.dao.clearCache(username, mailAccount);
        }
        if ((rslt = this.dao.fetchAccountSummaryFromStore(config, auth, username, mailAccount, start, max)).getMessagesStart() != start || rslt.getMessagesMax() != max) {
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Clearing AccountSummary cache for username '").append(username).append("', mailAccount '").append(mailAccount).append("':  start=[").append(rslt.getMessagesStart()).append(" prev, ").append(start).append(" current] ").append("count=[").append(rslt.getMessagesMax()).append(" prev, ").append(max).append(" current]");
                this.log.debug((Object)msg.toString());
            }
            this.dao.clearCache(username, mailAccount);
            rslt = this.dao.fetchAccountSummaryFromStore(config, auth, username, mailAccount, start, max);
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmailMessage getMessage(PortletRequest req, String messageId) {
        Folder inbox = null;
        try {
            boolean unread;
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            int mode = config.getMarkMessagesAsRead() ? 2 : 1;
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            inbox = this.dao.getUserInbox(session, config.getInboxFolderName());
            inbox.open(mode);
            Message message = inbox instanceof UIDFolder ? ((UIDFolder)inbox).getMessageByUID(Long.parseLong(messageId)) : inbox.getMessage(Integer.parseInt(messageId));
            boolean bl = unread = !message.isSet(Flags.Flag.SEEN);
            if (config.getMarkMessagesAsRead()) {
                message.setFlag(Flags.Flag.SEEN, true);
            }
            EmailMessage emailMessage = this.dao.wrapMessage(message, true, session);
            if (!config.getMarkMessagesAsRead()) {
                emailMessage.setUnread(unread);
            }
            EmailMessage emailMessage2 = emailMessage;
            return emailMessage2;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while retrieving individual message", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"IO exception while retrieving individual message", (Throwable)e);
        }
        catch (ScanException e) {
            this.log.error((Object)"AntiSamy scanning exception while retrieving individual message", (Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error((Object)"AntiSamy policy exception while retrieving individual message", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail store connection");
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessages(PortletRequest req, String[] messageIds) {
        Folder inbox = null;
        try {
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            inbox = this.dao.getUserInbox(session, config.getInboxFolderName());
            if (!(inbox instanceof UIDFolder)) {
                String msg = "Delete feature is supported only for UIDFolder instances";
                throw new UnsupportedOperationException(msg);
            }
            inbox.open(2);
            Message[] msgs = ((UIDFolder)inbox).getMessagesByUID(this.getMessageUidsAsLong(messageIds));
            inbox.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while deleting messages", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail store connection");
                }
            }
        }
        return false;
    }

    private long[] getMessageUidsAsLong(String[] messageIds) {
        long[] ids = new long[messageIds.length];
        int i = 0;
        for (String id : messageIds) {
            ids[i++] = Long.parseLong(id);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSeenFlag(PortletRequest req, String[] messageIds, boolean read) {
        Folder inbox = null;
        try {
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            inbox = this.dao.getUserInbox(session, config.getInboxFolderName());
            if (!(inbox instanceof UIDFolder)) {
                String msg = "Toggle unread feature is supported only for UIDFolder instances";
                throw new UnsupportedOperationException(msg);
            }
            inbox.open(2);
            Message[] msgs = ((UIDFolder)inbox).getMessagesByUID(this.getMessageUidsAsLong(messageIds));
            inbox.setFlags(msgs, new Flags(Flags.Flag.SEEN), read);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException e) {
            this.log.error((Object)"Messaging exception while deleting messages", (Throwable)e);
        }
        finally {
            if (inbox != null) {
                try {
                    inbox.close(false);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail inbox connection");
                }
                try {
                    inbox.getStore().close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail store connection");
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder[] getAllUserInboxFolders(PortletRequest req) {
        Store store = null;
        try {
            Folder[] allUserInboxFolders;
            MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
            IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
            if (authService == null) {
                String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
                this.log.error((Object)msg);
                throw new EmailPreviewException(msg);
            }
            Authenticator auth = authService.getAuthenticator(req, config);
            Session session = this.dao.openMailSession(config, auth);
            if (session == null) {
                String msg = "Argument 'session' cannot be null";
                throw new IllegalArgumentException(msg);
            }
            store = session.getStore();
            store.connect();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Mail store connection established");
            }
            Folder[] folderArray = allUserInboxFolders = store.getDefaultFolder().list("*");
            return folderArray;
        }
        catch (Exception e) {
            this.log.error((Object)"Can't get all user Inbox folders");
            Folder[] folderArray = null;
            return folderArray;
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Can't close correctly javamail store connection");
                }
            }
        }
    }
}

