/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.security;

import org.jasig.portlet.emailpreview.security.IStringEncryptionService;
import org.jasig.portlet.emailpreview.security.StringEncryptionException;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class JasyptPBEStringEncryptionServiceImpl
implements IStringEncryptionService,
InitializingBean {
    private PBEStringEncryptor encryptor = null;

    public void setStringEncryptor(PBEStringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public String encrypt(String plaintext) {
        try {
            return this.encryptor.encrypt(plaintext);
        }
        catch (EncryptionInitializationException e) {
            throw new StringEncryptionException("Encryption error. Verify an encryption password is configured in the email preview portlet's stringEncryptionService bean in applicationContent.xml", e);
        }
    }

    @Override
    public String decrypt(String cryptotet) {
        try {
            return this.encryptor.decrypt(cryptotet);
        }
        catch (EncryptionInitializationException e) {
            throw new StringEncryptionException("Decryption error. Was encryption password changed in the email preview portlet's stringEncryptionService bean in applicationContent.xml?", e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        String enc = this.encrypt(this.getClass().getName());
        Assert.notNull((Object)enc, (String)"String encryption service is not properly configured.");
        String dec = this.decrypt(enc);
        Assert.notNull((Object)dec, (String)"String decryption service is not properly configured.");
        Assert.isTrue((boolean)dec.equals(this.getClass().getName()), (String)("String decryption failed to decode the encrypted text " + enc));
    }
}

