/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth.pp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.MailPreferences;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;

public class PortletPreferencesCredentialsAuthenticationService
implements IAuthenticationService {
    public static final String KEY = "portletPreferences";
    private static final String ACCOUNT_NAME_ATTRIBUTE_KEY = "PortletPreferencesCredentialsAuthenticationService.ACCOUNT_NAME_ATTRIBUTE";
    private static final String ACCOUNT_NAME_ATTRIBUTE_LABEL = "If specified, use this user attribute as the mail account name (users won't be able to edit it)";
    private static final ConfigurationParameter ACCOUNT_NAME_ATTRIBUTE = new ConfigurationParameter("PortletPreferencesCredentialsAuthenticationService.ACCOUNT_NAME_ATTRIBUTE", "If specified, use this user attribute as the mail account name (users won't be able to edit it)", null, false);
    private final List<ConfigurationParameter> userParameters;
    private Map<String, ConfigurationParameter> configParams;

    public PortletPreferencesCredentialsAuthenticationService() {
        ArrayList<ConfigurationParameter> params = new ArrayList<ConfigurationParameter>();
        ConfigurationParameter usernameParam = new ConfigurationParameter();
        usernameParam.setKey(MailPreferences.MAIL_ACCOUNT.getKey());
        usernameParam.setLabel("Mail account name");
        usernameParam.setEncryptionRequired(true);
        params.add(usernameParam);
        ConfigurationParameter passwordParam = new ConfigurationParameter();
        passwordParam.setKey(MailPreferences.PASSWORD.getKey());
        passwordParam.setLabel("Password");
        passwordParam.setEncryptionRequired(true);
        params.add(passwordParam);
        this.userParameters = Collections.unmodifiableList(params);
        HashMap<String, ConfigurationParameter> m = new HashMap<String, ConfigurationParameter>();
        for (ConfigurationParameter param : this.userParameters) {
            m.put(param.getKey(), param);
        }
        this.configParams = Collections.unmodifiableMap(m);
    }

    @Override
    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return this.configParams;
    }

    @Override
    public boolean isConfigured(PortletRequest req, MailStoreConfiguration config) {
        String mailAccount = this.getMailAccountName(req, config);
        String password = config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        return mailAccount != null && password != null;
    }

    @Override
    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        String password = config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        return new SimplePasswordAuthenticator(this.getMailAccountName(request, config), password);
    }

    @Override
    public Credentials getCredentials(PortletRequest req, MailStoreConfiguration config) {
        String ntlmDomain = config.getExchangeDomain();
        String password = config.getAdditionalProperties().get(MailPreferences.PASSWORD.getKey());
        if (StringUtils.isBlank((String)ntlmDomain)) {
            throw new EmailPreviewException("NT domain must be specified for Exchange integration");
        }
        String username = this.getMailAccountName(req, config);
        int index = username.indexOf("@");
        username = index > 0 ? username.substring(0, index) : username;
        NTCredentials credentials = new NTCredentials(username, password, "paramDoesNotSeemToMatter", ntlmDomain);
        return credentials;
    }

    @Override
    public String getMailAccountName(PortletRequest req, MailStoreConfiguration config) {
        String rslt = null;
        String accountNameAttribute = config.getAdditionalProperties().get(ACCOUNT_NAME_ATTRIBUTE_KEY);
        if (!StringUtils.isBlank((String)accountNameAttribute)) {
            Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
            rslt = (String)userInfo.get(accountNameAttribute);
        } else {
            rslt = config.getAdditionalProperties().get(MailPreferences.MAIL_ACCOUNT.getKey());
        }
        String suffix = config.getUsernameSuffix();
        if (rslt != null && !StringUtils.isBlank((String)suffix)) {
            rslt = rslt.concat(suffix);
        }
        return rslt;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return Collections.singletonList(ACCOUNT_NAME_ATTRIBUTE);
    }

    @Override
    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return this.userParameters;
    }
}

