/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.KeyGenerator;
import com.googlecode.ehcache.annotations.PartialCacheKey;
import com.googlecode.ehcache.annotations.Property;
import com.googlecode.ehcache.annotations.TriggersRemove;
import com.microsoft.exchange.messages.BaseRequestType;
import com.microsoft.exchange.messages.BaseResponseMessageType;
import com.microsoft.exchange.messages.DeleteItem;
import com.microsoft.exchange.messages.FindFolder;
import com.microsoft.exchange.messages.FindFolderResponseMessageType;
import com.microsoft.exchange.messages.FindItem;
import com.microsoft.exchange.messages.FindItemResponseMessageType;
import com.microsoft.exchange.messages.FolderInfoResponseMessageType;
import com.microsoft.exchange.messages.GetFolder;
import com.microsoft.exchange.messages.GetItem;
import com.microsoft.exchange.messages.ItemInfoResponseMessageType;
import com.microsoft.exchange.messages.ResponseMessageType;
import com.microsoft.exchange.messages.UpdateItem;
import com.microsoft.exchange.messages.UpdateItemResponseMessageType;
import com.microsoft.exchange.types.ArrayOfRecipientsType;
import com.microsoft.exchange.types.BaseFolderType;
import com.microsoft.exchange.types.BasePathToElementType;
import com.microsoft.exchange.types.BodyTypeResponseType;
import com.microsoft.exchange.types.BodyTypeType;
import com.microsoft.exchange.types.ConflictResolutionType;
import com.microsoft.exchange.types.DefaultShapeNamesType;
import com.microsoft.exchange.types.DisposalType;
import com.microsoft.exchange.types.DistinguishedFolderIdNameType;
import com.microsoft.exchange.types.DistinguishedFolderIdType;
import com.microsoft.exchange.types.EmailAddressType;
import com.microsoft.exchange.types.FieldOrderType;
import com.microsoft.exchange.types.FindFolderParentType;
import com.microsoft.exchange.types.FindItemParentType;
import com.microsoft.exchange.types.FolderIdType;
import com.microsoft.exchange.types.FolderQueryTraversalType;
import com.microsoft.exchange.types.FolderResponseShapeType;
import com.microsoft.exchange.types.FolderType;
import com.microsoft.exchange.types.IndexBasePointType;
import com.microsoft.exchange.types.IndexedPageViewType;
import com.microsoft.exchange.types.ItemChangeType;
import com.microsoft.exchange.types.ItemIdType;
import com.microsoft.exchange.types.ItemQueryTraversalType;
import com.microsoft.exchange.types.ItemResponseShapeType;
import com.microsoft.exchange.types.ItemType;
import com.microsoft.exchange.types.MapiPropertyTypeType;
import com.microsoft.exchange.types.MessageDispositionType;
import com.microsoft.exchange.types.MessageType;
import com.microsoft.exchange.types.NonEmptyArrayOfBaseFolderIdsType;
import com.microsoft.exchange.types.NonEmptyArrayOfBaseItemIdsType;
import com.microsoft.exchange.types.NonEmptyArrayOfFieldOrdersType;
import com.microsoft.exchange.types.NonEmptyArrayOfItemChangeDescriptionsType;
import com.microsoft.exchange.types.NonEmptyArrayOfItemChangesType;
import com.microsoft.exchange.types.NonEmptyArrayOfPathsToElementType;
import com.microsoft.exchange.types.ObjectFactory;
import com.microsoft.exchange.types.PathToExtendedFieldType;
import com.microsoft.exchange.types.PathToUnindexedFieldType;
import com.microsoft.exchange.types.ResponseClassType;
import com.microsoft.exchange.types.SetItemFieldType;
import com.microsoft.exchange.types.SortDirectionType;
import com.microsoft.exchange.types.UnindexedFieldURIType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailMessageContent;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.ExchangeEmailMessage;
import org.jasig.portlet.emailpreview.ExchangeFolderDto;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.caching.IMessageCacheKeyGenerator;
import org.jasig.portlet.emailpreview.caching.IUsernameCacheKeyGenerator;
import org.jasig.portlet.emailpreview.caching.UsernameCacheKeyGeneratorImpl;
import org.jasig.portlet.emailpreview.caching.UsernameItemCacheKeyGeneratorImpl;
import org.jasig.portlet.emailpreview.dao.exchange.ExchangeAccountDaoImpl;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeAccountDao;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeCredentialsService;
import org.jasig.portlet.emailpreview.service.link.IEmailLinkService;
import org.jasig.portlet.emailpreview.service.link.ILinkServiceRegistry;
import org.jasig.portlet.emailpreview.util.MessageUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceOperations;
import org.springframework.ws.soap.client.core.SoapActionCallback;

public class ExchangeAccountDaoImpl
implements IExchangeAccountDao {
    protected static final String ROOT_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/";
    protected static final String FIND_FOLDER_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/FindFolder";
    protected static final String GET_FOLDER_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/GetFolder";
    protected static final String FIND_ITEM_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/FindItem";
    protected static final String GET_ITEM_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/GetItem";
    protected static final String DELETE_ITEM_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/DeleteItem";
    protected static final String UPDATE_ITEM_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/UpdateItem";
    private final ObjectFactory typeObjectFactory = new ObjectFactory();
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=true)
    private ILinkServiceRegistry linkServiceRegistry;
    private WebServiceOperations webServiceOperations;
    @Autowired(required=true)
    private MessageUtils messageUtils;
    @Autowired(required=true)
    private IExchangeCredentialsService credentialsService;
    private List<String> regexFoldernameExclusionPatterns;
    private List<Pattern> foldernameExclusions = new ArrayList();
    private Cache idCache;
    private IMessageCacheKeyGenerator idCacheKeyGenerator = new UsernameItemCacheKeyGeneratorImpl();
    private Cache folderCache;
    private IUsernameCacheKeyGenerator folderCacheKeyGenerator = new UsernameCacheKeyGeneratorImpl();
    protected String folderCacheKeyPrefix = "Exchange";

    public void setRegexFoldernameExclusionPatterns(List<String> regexFoldernameExclusionPatterns) {
        this.regexFoldernameExclusionPatterns = regexFoldernameExclusionPatterns;
        this.foldernameExclusions = new ArrayList();
        for (String pattern : regexFoldernameExclusionPatterns) {
            this.foldernameExclusions.add(Pattern.compile(pattern));
        }
    }

    public void setFolderCache(Cache folderCache) {
        this.folderCache = folderCache;
    }

    public void setFolderCacheKeyGenerator(IUsernameCacheKeyGenerator folderCacheKeyGenerator) {
        this.folderCacheKeyGenerator = folderCacheKeyGenerator;
    }

    public void setFolderCacheKeyPrefix(String folderCacheKeyPrefix) {
        this.folderCacheKeyPrefix = folderCacheKeyPrefix;
    }

    public void setIdCache(Cache idCache) {
        this.idCache = idCache;
    }

    public void setIdCacheKeyGenerator(IMessageCacheKeyGenerator idCacheKeyGenerator) {
        this.idCacheKeyGenerator = idCacheKeyGenerator;
    }

    public void setWebServiceOperations(WebServiceOperations webServiceOperations) {
        this.webServiceOperations = webServiceOperations;
    }

    public void setLinkServiceRegistry(ILinkServiceRegistry linkServiceRegistry) {
        this.linkServiceRegistry = linkServiceRegistry;
    }

    public void setMessageUtils(MessageUtils messageUtils) {
        this.messageUtils = messageUtils;
    }

    public void setCredentialsService(IExchangeCredentialsService credentialsService) {
        this.credentialsService = credentialsService;
    }

    @TriggersRemove(cacheName={"inboxCache"}, keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator", properties={@Property(name="includeMethod", value="false")}))
    public void clearAccountSummaryCache(String username, String mailAccount) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Removing cached AccountSummary for [mailAccount=").append(mailAccount).append(", username=").append(username).append("]");
            this.log.debug((Object)msg.toString());
        }
    }

    @Cacheable(cacheName="inboxCache", selfPopulating=true, keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator", properties={@Property(name="includeMethod", value="false")}))
    public AccountSummary fetchAccountSummaryFromStore(MailStoreConfiguration config, @PartialCacheKey String username, @PartialCacheKey String mailAccount, int start, int max, String folder) throws EmailPreviewException {
        try {
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Creating new AccountSummary for Exchange [").append("mailAccount=").append(mailAccount).append(", username=").append(username).append(", folder=").append(folder).append(", start=").append(start).append(", max=").append(max).append("]");
                this.log.debug((Object)msg.toString());
            }
            long startTime = System.currentTimeMillis();
            FolderType folderType = this.getFolder(folder);
            List messages = this.getMailboxItemSummaries(folderType, start, max);
            if (this.log.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                int messagesToDisplayCount = messages.size();
                this.log.debug((Object)("Finished looking up email account summary. Inbox size: " + folderType.getTotalCount() + " Unread message count: " + folderType.getUnreadCount() + " Total elapsed time: " + elapsedTime + "ms " + " Time per displayed message: " + (messagesToDisplayCount == 0 ? 0L : elapsedTime / (long)messagesToDisplayCount) + "ms"));
            }
            IEmailLinkService linkService = this.linkServiceRegistry.getEmailLinkService(config.getLinkServiceKey());
            String inboxUrl = null;
            if (linkService != null) {
                inboxUrl = linkService.getInboxUrl(config);
            }
            this.insertChangeKeysIntoCache(messages);
            return new AccountSummary(inboxUrl, messages, folderType.getUnreadCount().intValue(), folderType.getTotalCount().intValue(), start, max, true, null);
        }
        catch (EmailPreviewException e) {
            return new AccountSummary((Throwable)e);
        }
        catch (WebServiceClientException e) {
            return new AccountSummary((Throwable)e);
        }
    }

    private GetFolder createGetFolderSoapMessage(String folderName) {
        GetFolder msg = new GetFolder();
        NonEmptyArrayOfBaseFolderIdsType folderList = new NonEmptyArrayOfBaseFolderIdsType();
        if (DistinguishedFolderIdNameType.INBOX.value().equalsIgnoreCase(folderName)) {
            DistinguishedFolderIdType inboxFolderId = new DistinguishedFolderIdType();
            inboxFolderId.setId(DistinguishedFolderIdNameType.INBOX);
            folderList.getFolderIdsAndDistinguishedFolderIds().add(inboxFolderId);
        } else {
            String folderId = this.retrieveFolderId(folderName);
            if (folderId == null) {
                throw new EmailPreviewException("Invalid folder name '" + folderName + "'");
            }
            FolderIdType folderIdType = new FolderIdType();
            folderIdType.setId(folderId);
            folderList.getFolderIdsAndDistinguishedFolderIds().add(folderIdType);
        }
        msg.setFolderIds(folderList);
        FolderResponseShapeType shapeType = new FolderResponseShapeType();
        shapeType.setBaseShape(DefaultShapeNamesType.DEFAULT);
        msg.setFolderShape(shapeType);
        return msg;
    }

    private FolderType getFolder(String folderName) {
        FolderInfoResponseMessageType response = (FolderInfoResponseMessageType)this.sendMessageAndExtractSingleResponse((BaseRequestType)this.createGetFolderSoapMessage(folderName), GET_FOLDER_SOAP_ACTION);
        List folders = response.getFolders().getFoldersAndCalendarFoldersAndContactsFolders();
        if (folders.size() != 1) {
            this.log.error((Object)("Expected 1 folder to find folder, received " + folders.size()));
            throw new EmailPreviewException("Multiple folders returned when querying for inbox");
        }
        FolderType folder = (FolderType)folders.get(0);
        return folder;
    }

    private FindItem createFindItemsSoapMessage(FolderType folder, int start, int fetchSize) {
        FindItem msg = new FindItem();
        NonEmptyArrayOfBaseFolderIdsType folderList = new NonEmptyArrayOfBaseFolderIdsType();
        folderList.getFolderIdsAndDistinguishedFolderIds().add(folder.getFolderId());
        msg.setParentFolderIds(folderList);
        msg.setTraversal(ItemQueryTraversalType.SHALLOW);
        ItemResponseShapeType shapeType = new ItemResponseShapeType();
        shapeType.setBaseShape(DefaultShapeNamesType.DEFAULT);
        this.addAdditionalPropertyReplied(shapeType);
        msg.setItemShape(shapeType);
        IndexedPageViewType paging = new IndexedPageViewType();
        int totalMessageCount = folder.getTotalCount();
        int entriesToReturn = Math.min(fetchSize, totalMessageCount - start);
        paging.setOffset(start);
        paging.setMaxEntriesReturned(Integer.valueOf(entriesToReturn));
        paging.setBasePoint(IndexBasePointType.BEGINNING);
        msg.setIndexedPageItemView(paging);
        FieldOrderType order = new FieldOrderType();
        order.setOrder(SortDirectionType.DESCENDING);
        PathToUnindexedFieldType orderField = new PathToUnindexedFieldType();
        orderField.setFieldURI(UnindexedFieldURIType.ITEM_DATE_TIME_RECEIVED);
        order.setPath(this.typeObjectFactory.createFieldURI(orderField));
        NonEmptyArrayOfFieldOrdersType ordersType = new NonEmptyArrayOfFieldOrdersType();
        ordersType.getFieldOrders().add(order);
        msg.setSortOrder(ordersType);
        return msg;
    }

    private void addAdditionalPropertyReplied(ItemResponseShapeType shapeType) {
        NonEmptyArrayOfPathsToElementType props = new NonEmptyArrayOfPathsToElementType();
        PathToExtendedFieldType fieldType = new PathToExtendedFieldType();
        fieldType.setPropertyTag("0x1081");
        fieldType.setPropertyType(MapiPropertyTypeType.INTEGER);
        props.getPaths().add(this.typeObjectFactory.createPath((BasePathToElementType)fieldType));
        shapeType.setAdditionalProperties(props);
    }

    private List<ExchangeEmailMessage> getMailboxItemSummaries(FolderType folder, int start, int fetchSize) {
        FindItem soapMessage = this.createFindItemsSoapMessage(folder, start, fetchSize);
        FindItemResponseMessageType response = (FindItemResponseMessageType)this.sendMessageAndExtractSingleResponse((BaseRequestType)soapMessage, FIND_ITEM_SOAP_ACTION);
        FindItemParentType rootFolder = response.getRootFolder();
        List items = rootFolder.getItems().getItemsAndMessagesAndCalendarItems();
        ArrayList<ExchangeEmailMessage> messages = new ArrayList<ExchangeEmailMessage>();
        int messageNumber = start;
        String contentType = null;
        boolean answered = false;
        boolean deleted = false;
        for (ItemType itemType : items) {
            MessageType item = (MessageType)itemType;
            ExchangeEmailMessage message = new ExchangeEmailMessage(messageNumber, item.getItemId().getId(), item.getItemId().getChangeKey(), item.getFrom().getMailbox().getName(), this.messageUtils.cleanHTML(item.getSubject()), new Date(item.getDateTimeSent().toGregorianCalendar().getTimeInMillis()), item.isIsRead() == false, answered, deleted, item.isHasAttachments().booleanValue(), contentType, null, null);
            messages.add(message);
            ++messageNumber;
        }
        return messages;
    }

    public EmailMessage getMessage(String uuid, MailStoreConfiguration storeConfig) {
        ItemInfoResponseMessageType response = (ItemInfoResponseMessageType)this.sendMessageAndExtractSingleResponse((BaseRequestType)this.createGetItemSoapMessage(uuid, DefaultShapeNamesType.ALL_PROPERTIES), GET_ITEM_SOAP_ACTION);
        MessageType message = (MessageType)response.getItems().getItemsAndMessagesAndCalendarItems().get(0);
        String sender = this.getOriginatorEmailAddress(message);
        boolean answered = false;
        boolean deleted = false;
        String contentType = message.getBody().getBodyType().value();
        EmailMessageContent content = new EmailMessageContent(this.messageUtils.cleanHTML(message.getBody().getValue()), BodyTypeType.HTML.equals((Object)message.getBody().getBodyType()));
        String allRecipients = this.getAllToRecipients(message);
        ExchangeEmailMessage msg = new ExchangeEmailMessage(0, message.getItemId().getId(), message.getItemId().getChangeKey(), sender, this.messageUtils.cleanHTML(message.getSubject()), new Date(message.getDateTimeSent().toGregorianCalendar().getTimeInMillis()), message.isIsRead() == false, answered, deleted, message.isHasAttachments().booleanValue(), contentType, content, allRecipients);
        this.insertChangeKeyIntoCache(msg.getMessageId(), msg.getExchangeChangeKey());
        return msg;
    }

    private String getAllToRecipients(MessageType message) {
        return this.getAllRecipients(message.getToRecipients());
    }

    private String getAllRecipients(ArrayOfRecipientsType addrs) {
        StringBuilder str = new StringBuilder();
        for (EmailAddressType addr : addrs.getMailboxes()) {
            str.append(this.formatEmailAddress(addr));
            str.append("; ");
        }
        str.deleteCharAt(str.length() - 1);
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    private String getOriginatorEmailAddress(MessageType message) {
        if (message.getFrom() != null) {
            return this.formatEmailAddress(message.getFrom().getMailbox());
        }
        if (message.getSender() != null) {
            return this.formatEmailAddress(message.getSender().getMailbox());
        }
        return "Not specified";
    }

    private String formatEmailAddress(EmailAddressType emailAddr) {
        return emailAddr.getName() + "<" + emailAddr.getEmailAddress() + ">";
    }

    public ItemIdType getMessageChangeKey(String uuid) {
        ItemInfoResponseMessageType response = (ItemInfoResponseMessageType)this.sendMessageAndExtractSingleResponse((BaseRequestType)this.createGetItemSoapMessage(uuid, DefaultShapeNamesType.ID_ONLY), GET_ITEM_SOAP_ACTION);
        MessageType message = (MessageType)response.getItems().getItemsAndMessagesAndCalendarItems().get(0);
        return message.getItemId();
    }

    private GetItem createGetItemSoapMessage(String uuid, DefaultShapeNamesType itemShape) {
        GetItem msg = new GetItem();
        NonEmptyArrayOfBaseItemIdsType itemList = new NonEmptyArrayOfBaseItemIdsType();
        ItemIdType item = new ItemIdType();
        item.setId(uuid);
        itemList.getItemIdsAndOccurrenceItemIdsAndRecurringMasterItemIds().add(item);
        msg.setItemIds(itemList);
        ItemResponseShapeType shape = new ItemResponseShapeType();
        shape.setBaseShape(itemShape);
        shape.setIncludeMimeContent(Boolean.valueOf(true));
        shape.setBodyType(BodyTypeResponseType.BEST);
        this.addAdditionalPropertyReplied(shape);
        msg.setItemShape(shape);
        return msg;
    }

    public void deleteMessages(String[] uuids) {
        this.sendMessageAndExtractSingleResponse((BaseRequestType)this.createDeleteItemsSoapMessage(uuids), DELETE_ITEM_SOAP_ACTION);
    }

    private DeleteItem createDeleteItemsSoapMessage(String[] uuids) {
        DeleteItem msg = new DeleteItem();
        msg.setDeleteType(DisposalType.MOVE_TO_DELETED_ITEMS);
        NonEmptyArrayOfBaseItemIdsType itemList = new NonEmptyArrayOfBaseItemIdsType();
        for (String uuid : uuids) {
            ItemIdType item = new ItemIdType();
            item.setId(uuid);
            itemList.getItemIdsAndOccurrenceItemIdsAndRecurringMasterItemIds().add(item);
        }
        msg.setItemIds(itemList);
        return msg;
    }

    public void setMessageReadStatus(String[] uuids, boolean read) {
        UpdateItemResponseMessageType soapResponse = (UpdateItemResponseMessageType)this.sendMessageAndExtractSingleResponse((BaseRequestType)this.createUpdateItemSoapMessage(uuids, read), UPDATE_ITEM_SOAP_ACTION);
        List updatedItems = soapResponse.getItems().getItemsAndMessagesAndCalendarItems();
        for (ItemType updatedItem : updatedItems) {
            ItemIdType itemId = updatedItem.getItemId();
            this.insertChangeKeyIntoCache(itemId);
        }
    }

    private UpdateItem createUpdateItemSoapMessage(String[] uuids, boolean read) {
        UpdateItem soapMessage = new UpdateItem();
        SetItemFieldType change = new SetItemFieldType();
        PathToUnindexedFieldType field = new PathToUnindexedFieldType();
        field.setFieldURI(UnindexedFieldURIType.MESSAGE_IS_READ);
        change.setPath(this.typeObjectFactory.createFieldURI(field));
        MessageType message = new MessageType();
        message.setIsRead(Boolean.valueOf(read));
        change.setMessage(message);
        NonEmptyArrayOfItemChangeDescriptionsType changes = new NonEmptyArrayOfItemChangeDescriptionsType();
        changes.getAppendToItemFieldsAndSetItemFieldsAndDeleteItemFields().add(change);
        NonEmptyArrayOfItemChangesType changeList = new NonEmptyArrayOfItemChangesType();
        for (String uuid : uuids) {
            ItemChangeType itemChange = new ItemChangeType();
            itemChange.setItemId(this.getItemIdType(uuid));
            itemChange.setUpdates(changes);
            changeList.getItemChanges().add(itemChange);
        }
        soapMessage.setItemChanges(changeList);
        soapMessage.setMessageDisposition(MessageDispositionType.SAVE_ONLY);
        soapMessage.setConflictResolution(ConflictResolutionType.ALWAYS_OVERWRITE);
        return soapMessage;
    }

    public List<ExchangeFolderDto> getAllUserInboxFolders() {
        this.log.debug((Object)"Requested fetching all folders");
        String key = this.folderCacheKeyGenerator.getKey(this.credentialsService.getUsername(), this.folderCacheKeyPrefix);
        Element element = this.folderCache.get((Serializable)((Object)key));
        if (element != null) {
            return (List)((Object)element.getValue());
        }
        this.log.debug((Object)"Item not in cache. Fetching all folders");
        FindFolderResponseMessageType response = (FindFolderResponseMessageType)this.sendMessageAndExtractSingleResponse((BaseRequestType)this.createFindFoldersSoapMessage(), FIND_FOLDER_SOAP_ACTION);
        FindFolderParentType rootFolder = response.getRootFolder();
        List folderList = rootFolder.getFolders().getFoldersAndCalendarFoldersAndContactsFolders();
        ArrayList<ExchangeFolderDto> folders = new ArrayList<ExchangeFolderDto>(folderList.size());
        for (BaseFolderType baseFolder : folderList) {
            if (!baseFolder.getClass().equals(FolderType.class) || this.matchesExcludedFolders(baseFolder)) continue;
            FolderType exchangeFolder = (FolderType)baseFolder;
            ExchangeFolderDto folder = new ExchangeFolderDto(exchangeFolder.getFolderId().getId(), exchangeFolder.getDisplayName(), exchangeFolder.getTotalCount().intValue(), exchangeFolder.getUnreadCount().intValue());
            folders.add(folder);
        }
        this.folderCache.put(new Element((Object)key, folders));
        return folders;
    }

    private String retrieveFolderId(String folderName) {
        String key = this.folderCacheKeyGenerator.getKey(this.credentialsService.getUsername(), this.folderCacheKeyPrefix);
        Element element = this.folderCache.get((Serializable)((Object)key));
        List folders = element != null ? (List)((Object)element.getValue()) : this.getAllUserInboxFolders();
        for (ExchangeFolderDto folder : folders) {
            if (!folderName.equals(folder.getName())) continue;
            return folder.getId();
        }
        return null;
    }

    private boolean matchesExcludedFolders(BaseFolderType folder) {
        String folderName = folder.getDisplayName();
        for (Pattern pattern : this.foldernameExclusions) {
            Matcher matcher = pattern.matcher(folderName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private FindFolder createFindFoldersSoapMessage() {
        FindFolder msg = new FindFolder();
        NonEmptyArrayOfBaseFolderIdsType folderList = new NonEmptyArrayOfBaseFolderIdsType();
        DistinguishedFolderIdType inboxFolderId = new DistinguishedFolderIdType();
        inboxFolderId.setId(DistinguishedFolderIdNameType.MSGFOLDERROOT);
        folderList.getFolderIdsAndDistinguishedFolderIds().add(inboxFolderId);
        msg.setParentFolderIds(folderList);
        msg.setTraversal(FolderQueryTraversalType.DEEP);
        FolderResponseShapeType shapeType = new FolderResponseShapeType();
        shapeType.setBaseShape(DefaultShapeNamesType.DEFAULT);
        msg.setFolderShape(shapeType);
        return msg;
    }

    private BaseResponseMessageType sendSoapRequest(BaseRequestType soapRequest, String soapAction) {
        try {
            SoapActionCallback actionCallback = new SoapActionCallback(soapAction);
            1 customCallback = new /* Unavailable Anonymous Inner Class!! */;
            BaseResponseMessageType response = (BaseResponseMessageType)this.webServiceOperations.marshalSendAndReceive((Object)soapRequest, (WebServiceMessageCallback)customCallback);
            return response;
        }
        catch (WebServiceClientException e) {
            throw new EmailPreviewException((Throwable)e);
        }
    }

    private ResponseMessageType sendMessageAndExtractSingleResponse(BaseRequestType soapRequest, String soapAction) {
        BaseResponseMessageType soapResponse = this.sendSoapRequest(soapRequest, soapAction);
        boolean warning = false;
        boolean error = false;
        StringBuilder msg = new StringBuilder();
        List responseMessages = soapResponse.getResponseMessages().getCreateItemResponseMessagesAndDeleteItemResponseMessagesAndGetItemResponseMessages();
        for (JAXBElement resp : responseMessages) {
            if (ResponseClassType.ERROR.equals((Object)((ResponseMessageType)resp.getValue()).getResponseClass())) {
                error = true;
                msg.append("Error: ").append(((ResponseMessageType)resp.getValue()).getResponseCode().value()).append(": ").append(((ResponseMessageType)resp.getValue()).getMessageText()).append("\n");
                continue;
            }
            if (!ResponseClassType.WARNING.equals((Object)((ResponseMessageType)resp.getValue()).getResponseClass())) continue;
            warning = true;
            msg.append("Warning: ").append(((ResponseMessageType)resp.getValue()).getResponseCode().value()).append(": ").append(((ResponseMessageType)resp.getValue()).getMessageText()).append("\n");
        }
        if (warning || error) {
            StringBuilder errorMessage = new StringBuilder("Unexpected response from soap action: " + soapAction + ".\nSoap Request: " + soapRequest.toString() + "\n");
            errorMessage.append((CharSequence)msg);
            if (error) {
                throw new EmailPreviewException("Error performing Exchange web service action " + soapAction + ". Error code is " + errorMessage.toString());
            }
            this.log.warn((Object)("Received warning response to soap request " + soapAction + ". Error text is:\n" + errorMessage.toString()));
            throw new EmailPreviewException("Unable to perform " + soapAction + " operation; try again later. Message text: " + errorMessage.toString());
        }
        return (ResponseMessageType)((JAXBElement)responseMessages.get(0)).getValue();
    }

    private void insertChangeKeysIntoCache(List<ExchangeEmailMessage> messages) {
        for (ExchangeEmailMessage message : messages) {
            this.insertChangeKeyIntoCache(message.getMessageId(), message.getExchangeChangeKey());
        }
    }

    private void insertChangeKeyIntoCache(String uuid, String changeKey) {
        String key = this.idCacheKeyGenerator.getKey(this.credentialsService.getUsername(), uuid);
        this.idCache.put(new Element((Serializable)((Object)key), (Serializable)((Object)changeKey)));
    }

    private void insertChangeKeyIntoCache(ItemIdType itemId) {
        this.insertChangeKeyIntoCache(itemId.getId(), itemId.getChangeKey());
    }

    private ItemIdType getItemIdType(String uuid) {
        String key = this.idCacheKeyGenerator.getKey(this.credentialsService.getUsername(), uuid);
        Element changeKey = this.idCache.get((Serializable)((Object)key));
        if (changeKey == null) {
            ItemIdType itemId = this.getMessageChangeKey(uuid);
            this.insertChangeKeyIntoCache(uuid, itemId.getChangeKey());
            return itemId;
        }
        ItemIdType itemIdType = new ItemIdType();
        itemIdType.setId(uuid);
        itemIdType.setChangeKey((String)((Object)changeKey.getValue()));
        return itemIdType;
    }
}

