/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import javax.mail.Folder;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeAccountDao;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeCredentialsService;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.springframework.beans.factory.annotation.Autowired;

public class ExchangeAccountService
implements IEmailAccountService {
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    private IServiceBroker serviceBroker;
    @Autowired
    private IExchangeAccountDao dao;
    @Autowired
    private IExchangeCredentialsService exchangeCredentialsService;
    protected final Log log = LogFactory.getLog(this.getClass());

    public void setExchangeCredentialsService(IExchangeCredentialsService exchangeCredentialsService) {
        this.exchangeCredentialsService = exchangeCredentialsService;
    }

    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh, String folder) throws EmailPreviewException {
        AccountSummary rslt;
        String username = req.getRemoteUser();
        if (username == null) {
            throw new EmailPreviewException("Anonymous access is not supported");
        }
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        config.setInboxFolderName(folder);
        IAuthenticationService authService = this.populateCredentials(req, config);
        String mailAccount = authService.getMailAccountName(req, config);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Account summary requested for " + username + ", folder=" + folder + ", start=" + start + " max=" + max + " refresh=" + refresh));
        }
        if (refresh) {
            this.dao.clearAccountSummaryCache(username, mailAccount);
        }
        if ((rslt = this.dao.fetchAccountSummaryFromStore(config, username, mailAccount, start, max, folder)).getMessagesStart() != start || rslt.getMessagesMax() != max) {
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Clearing AccountSummary cache for username '").append(username).append("', mailAccount '").append(mailAccount).append("':  start=[").append(rslt.getMessagesStart()).append(" prev, ").append(start).append(" current] ").append("count=[").append(rslt.getMessagesMax()).append(" prev, ").append(max).append(" current]");
                this.log.debug((Object)msg.toString());
            }
            this.dao.clearAccountSummaryCache(username, mailAccount);
            rslt = this.dao.fetchAccountSummaryFromStore(config, username, mailAccount, start, max, folder);
        }
        return rslt;
    }

    private IAuthenticationService populateCredentials(PortletRequest req, MailStoreConfiguration config) {
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (authService == null) {
            String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
            this.log.error((Object)msg);
            throw new EmailPreviewException(msg);
        }
        this.exchangeCredentialsService.initialize(req, config, authService);
        return authService;
    }

    public EmailMessage getMessage(PortletRequest req, String messageId) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.populateCredentials(req, config);
        if (config.getMarkMessagesAsRead()) {
            this.setSeenFlag(req, new String[]{messageId}, true);
            this.dao.clearAccountSummaryCache(req.getRemoteUser(), authService.getMailAccountName(req, config));
        }
        return this.dao.getMessage(messageId, config);
    }

    public boolean deleteMessages(PortletRequest req, String[] messageIds) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.populateCredentials(req, config);
        this.dao.deleteMessages(messageIds);
        return true;
    }

    public boolean setSeenFlag(PortletRequest req, String[] messageIds, boolean read) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.populateCredentials(req, config);
        this.dao.setMessageReadStatus(messageIds, read);
        return true;
    }

    public Folder[] getAllUserInboxFolders(PortletRequest req) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.populateCredentials(req, config);
        return this.dao.getAllUserInboxFolders().toArray(new Folder[0]);
    }
}

