/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth.cas;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.http.auth.Credentials;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;
import org.jasig.portlet.emailpreview.service.auth.cas.ICASProxyTicketService;

public class CasAuthenticationService
implements IAuthenticationService {
    protected String key = "cas";
    protected ICASProxyTicketService casTicketService;
    protected String serviceUrl;
    protected String CAS_ASSERTION_KEY = "CAS_ASSERTION_KEY";

    public void setCasTicketService(ICASProxyTicketService casTicketService) {
        this.casTicketService = casTicketService;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    protected String getProxyPrincipalname(PortletRequest request) {
        Assertion casAssertion = this.getCasAssertion(request);
        String proxyPrincipalname = casAssertion.getPrincipal().getName();
        return proxyPrincipalname;
    }

    protected Assertion getCasAssertion(PortletRequest request) {
        PortletSession session = request.getPortletSession(true);
        Assertion casAssertion = (Assertion)session.getAttribute(this.CAS_ASSERTION_KEY);
        if (casAssertion == null) {
            casAssertion = this.casTicketService.getProxyTicket(request);
            if (casAssertion == null) {
                throw new RuntimeException("CasAssertion is null : Auth ProxyCAS failed ? Please check yours CAS configurations.");
            }
            session.setAttribute(this.CAS_ASSERTION_KEY, (Object)casAssertion);
        }
        return casAssertion;
    }

    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return Collections.emptyMap();
    }

    public boolean isConfigured(PortletRequest request, MailStoreConfiguration config) {
        return true;
    }

    public Authenticator getAuthenticator(PortletRequest request, MailStoreConfiguration config) {
        Assertion casAssertion = this.getCasAssertion(request);
        String proxyPrincipalname = this.getProxyPrincipalname(request);
        String proxyTicket = this.casTicketService.getCasServiceToken(casAssertion, this.serviceUrl);
        return new SimplePasswordAuthenticator(proxyPrincipalname, proxyTicket);
    }

    public Credentials getCredentials(PortletRequest req, MailStoreConfiguration config) {
        throw new UnsupportedOperationException("CAS ticket doesn't make sense with Exchange integration");
    }

    public String getMailAccountName(PortletRequest request, MailStoreConfiguration config) {
        String proxyPrincipalname = this.getProxyPrincipalname(request);
        return proxyPrincipalname;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return Collections.emptyList();
    }

    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return Collections.emptyList();
    }
}

