/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import com.microsoft.exchange.autodiscover.ArrayOfUserResponse;
import com.microsoft.exchange.autodiscover.ErrorCode;
import com.microsoft.exchange.autodiscover.ExchangeVersion;
import com.microsoft.exchange.autodiscover.GetUserSettingsRequest;
import com.microsoft.exchange.autodiscover.GetUserSettingsRequestMessage;
import com.microsoft.exchange.autodiscover.GetUserSettingsResponse;
import com.microsoft.exchange.autodiscover.GetUserSettingsResponseMessage;
import com.microsoft.exchange.autodiscover.ObjectFactory;
import com.microsoft.exchange.autodiscover.RequestedSettings;
import com.microsoft.exchange.autodiscover.StringSetting;
import com.microsoft.exchange.autodiscover.User;
import com.microsoft.exchange.autodiscover.UserResponse;
import com.microsoft.exchange.autodiscover.UserSetting;
import com.microsoft.exchange.autodiscover.UserSettings;
import com.microsoft.exchange.autodiscover.Users;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.caching.EWSEndpointUriCacheKeyGeneratorImpl;
import org.jasig.portlet.emailpreview.caching.IEWSEndpoingUriCacheKeyGenerator;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeAutoDiscoverDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Marshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceOperations;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.xml.transform.StringResult;

public class ExchangeAutoDiscoverDaoImpl
implements IExchangeAutoDiscoverDao {
    protected static final String AUTODISCOVER_SCHEMA = "http://schemas.microsoft.com/exchange/autodiscover/outlook/requestschema/2006";
    protected static final String AUTODISCOVER_RESPONSE_SCHEMA = "http://schemas.microsoft.com/exchange/autodiscover/outlook/responseschema/2006a";
    protected static final QName REQUEST_SERVER_VERSION_QNAME = new QName("http://schemas.microsoft.com/exchange/2010/Autodiscover", "RequestedServerVersion", "a");
    protected static final QName SOAP_ACTION_HEADER_QNAME = new QName("http://www.w3.org/2005/08/addressing", "Action", "wsa");
    protected static final String SOAP_ACTION_BASE = "http://schemas.microsoft.com/exchange/2010/Autodiscover/Autodiscover/";
    protected static final String GET_USER_SETTINGS_ACTION = "http://schemas.microsoft.com/exchange/2010/Autodiscover/Autodiscover/GetUserSettings";
    private static final String INTERNAL_EWS_SERVER = "InternalEwsUrl";
    private static final String EXTERNAL_EWS_SERVER = "ExternalEwsUrl";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String EWSServerURI = "https://{server}/EWS/exchange.asmx";
    private final ObjectFactory objectFactory = new ObjectFactory();
    private Marshaller marshaller;
    private Cache ewsEndpointUriCache;
    private IEWSEndpoingUriCacheKeyGenerator ewsEndpointUriCacheKeyGenerator = new EWSEndpointUriCacheKeyGeneratorImpl();
    @Autowired
    @Qualifier(value="exchangeAutodiscover")
    private WebServiceOperations webServiceOperations;
    private List<String> autoDiscoverURIs = Arrays.asList("https://{server}/autodiscover/autodiscover.svc", "https://autodiscover.{server}/autodiscover/autodiscover.svc");

    public void setWebServiceOperations(WebServiceOperations webServiceOperations) {
        this.webServiceOperations = webServiceOperations;
    }

    public void setEwsEndpointUriCache(Cache ewsEndpointUriCache) {
        this.ewsEndpointUriCache = ewsEndpointUriCache;
    }

    public void setEwsEndpointUriCacheKeyGenerator(IEWSEndpoingUriCacheKeyGenerator ewsEndpointUriCacheKeyGenerator) {
        this.ewsEndpointUriCacheKeyGenerator = ewsEndpointUriCacheKeyGenerator;
    }

    public void setAutoDiscoverURIs(List<String> autoDiscoverURIs) {
        this.autoDiscoverURIs = autoDiscoverURIs;
    }

    public void setEWSServerURI(String EWSServerURI) {
        this.EWSServerURI = EWSServerURI;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public String getEndpointUri(MailStoreConfiguration config) {
        String cacheKey = this.ewsEndpointUriCacheKeyGenerator.getKey(config);
        Element element = this.ewsEndpointUriCache.get((Serializable)((Object)cacheKey));
        if (element == null) {
            String endpointUri;
            if (config.isExchangeAutodiscover()) {
                this.log.debug("Cache miss. Autodiscover enabled. Looking up EWS endpoint for mail account {} at host {}", (Object)config.getMailAccount(), (Object)config.getHost());
                endpointUri = this.getAccountServiceUrl(config);
                this.log.info("Caching Autodiscover endpoint {} for mail account {}", (Object)endpointUri, (Object)config.getMailAccount());
            } else {
                endpointUri = this.EWSServerURI.replace("{server}", config.getHost());
                this.log.debug("Cache miss. Not using Autodiscover. Caching computed EWS endpoint {} for mail account {}", (Object)endpointUri, (Object)config.getMailAccount());
            }
            Element el = new Element((Serializable)((Object)cacheKey), (Serializable)((Object)endpointUri));
            this.ewsEndpointUriCache.put(el);
            return endpointUri;
        }
        String uri = (String)((Object)element.getValue());
        this.log.debug("Cache hit for EWS endpoint for mail account {} to endpoint URI {}", (Object)config.getMailAccount(), (Object)uri);
        return uri;
    }

    private String getAccountServiceUrl(MailStoreConfiguration config) {
        UserSettings userSettings = this.sendMessageAndExtractSingleResponse(this.createGetUserSettingsSoapMessage(config.getMailAccount()), GET_USER_SETTINGS_ACTION, config);
        String internalUri = null;
        String externalUri = null;
        for (UserSetting userSetting : userSettings.getUserSettings()) {
            String potentialAccountServiceUrl = (String)((StringSetting)userSetting).getValue().getValue();
            if (EXTERNAL_EWS_SERVER.equals(userSetting.getName())) {
                externalUri = potentialAccountServiceUrl;
            }
            if (!INTERNAL_EWS_SERVER.equals(userSetting.getName())) continue;
            internalUri = potentialAccountServiceUrl;
        }
        if (internalUri == null && externalUri == null) {
            throw new EmailPreviewException("Unable to find EWS Server URI in properies ExternalEwsUrl or InternalEwsUrl from User's Autodiscover record");
        }
        return internalUri != null ? internalUri : externalUri;
    }

    private GetUserSettingsRequestMessage createGetUserSettingsSoapMessage(String emailAddress) {
        GetUserSettingsRequest msg = this.objectFactory.createGetUserSettingsRequest();
        User user = this.objectFactory.createUser();
        user.setMailbox(emailAddress);
        Users users = this.objectFactory.createUsers();
        users.getUsers().add(user);
        msg.setUsers(users);
        msg.setRequestedVersion(ExchangeVersion.EXCHANGE_2010);
        RequestedSettings settings = this.objectFactory.createRequestedSettings();
        settings.getSettings().add(EXTERNAL_EWS_SERVER);
        settings.getSettings().add(INTERNAL_EWS_SERVER);
        msg.setRequestedSettings(settings);
        GetUserSettingsRequestMessage request = this.objectFactory.createGetUserSettingsRequestMessage();
        request.setRequest(this.objectFactory.createGetUserSettingsRequestMessageRequest(msg));
        return request;
    }

    private UserSettings sendMessageAndExtractSingleResponse(GetUserSettingsRequestMessage soapRequest, String soapAction, MailStoreConfiguration config) {
        GetUserSettingsResponseMessage soapResponseMessage = (GetUserSettingsResponseMessage)this.sendSoapRequest(soapRequest, soapAction, config);
        GetUserSettingsResponse soapResponse = (GetUserSettingsResponse)soapResponseMessage.getResponse().getValue();
        UserSettings userSettings = null;
        boolean warning = false;
        boolean error = false;
        StringBuilder msg = new StringBuilder();
        if (!ErrorCode.NO_ERROR.equals((Object)soapResponse.getErrorCode())) {
            error = true;
            msg.append("Error: ").append(soapResponse.getErrorCode().value()).append(": ").append((String)soapResponse.getErrorMessage().getValue()).append("\n");
        } else {
            ArrayList responses;
            JAXBElement<ArrayOfUserResponse> JAXBresponseArray = soapResponse.getUserResponses();
            ArrayOfUserResponse responseArray = JAXBresponseArray != null ? (ArrayOfUserResponse)JAXBresponseArray.getValue() : null;
            ArrayList arrayList = responses = responseArray != null ? responseArray.getUserResponses() : new ArrayList();
            if (responses.size() == 0) {
                error = true;
                msg.append("Error: Autodiscovery returned no Exchange mail server for mailbox");
            } else if (responses.size() > 1) {
                warning = true;
                msg.append("Warning: Autodiscovery returned multiple responses for Exchange server mailbox query");
            } else {
                UserResponse userResponse = (UserResponse)responses.get(0);
                if (!ErrorCode.NO_ERROR.equals((Object)userResponse.getErrorCode())) {
                    error = true;
                    msg.append("Received error message obtaining user mailbox's server. Error " + userResponse.getErrorCode().value() + ": " + (String)userResponse.getErrorMessage().getValue());
                }
                userSettings = (UserSettings)userResponse.getUserSettings().getValue();
            }
        }
        if (warning || error) {
            StringBuilder errorMessage = new StringBuilder("Unexpected response from soap action: " + soapAction + ".\nSoap Request: " + soapRequest.toString() + "\n");
            errorMessage.append((CharSequence)msg);
            if (error) {
                throw new EmailPreviewException("Error performing Exchange web service action " + soapAction + ". Error code is " + errorMessage.toString());
            }
            this.log.warn("Received warning response to soap request " + soapAction + ". Error text is:\n" + errorMessage.toString());
            throw new EmailPreviewException("Unable to perform " + soapAction + " operation; try again later. Message text: " + errorMessage.toString());
        }
        return userSettings;
    }

    private Object sendSoapRequest(Object soapRequest, String soapAction, MailStoreConfiguration config) {
        WebServiceClientException ex = null;
        Iterator<String> i$ = this.autoDiscoverURIs.iterator();
        if (i$.hasNext()) {
            String pattern = i$.next();
            String uri = pattern.replace("{server}", config.getHost());
            try {
                Object response = this.sendSoapMessageToServer(soapRequest, soapAction, uri);
                return response;
            }
            catch (WebServiceClientException e) {
                ex = e;
                throw new EmailPreviewException(e);
            }
        }
        throw new EmailPreviewException("Unable to use autodiscover on host " + config.getHost(), ex);
    }

    private Object sendSoapMessageToServer(Object soapRequest, String soapAction, String uri) {
        SoapActionCallback actionCallback = new SoapActionCallback(soapAction);
        WebServiceMessageCallback customCallback = new WebServiceMessageCallback((WebServiceMessageCallback)actionCallback, soapAction){
            final /* synthetic */ WebServiceMessageCallback val$actionCallback;
            final /* synthetic */ String val$soapAction;
            {
                this.val$actionCallback = webServiceMessageCallback;
                this.val$soapAction = string;
            }

            public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
                this.val$actionCallback.doWithMessage(message);
                SoapMessage soap = (SoapMessage)message;
                soap.getEnvelope().getHeader().addHeaderElement(REQUEST_SERVER_VERSION_QNAME).setText(ExchangeVersion.EXCHANGE_2010.value());
                soap.getEnvelope().getHeader().addHeaderElement(SOAP_ACTION_HEADER_QNAME).setText(this.val$soapAction);
            }
        };
        if (this.log.isDebugEnabled()) {
            StringResult message = new StringResult();
            try {
                this.marshaller.marshal(soapRequest, (Result)message);
                this.log.debug("Attempting to send SOAP request to {}\nSoap Action: {}\nSoap message body (not exact, log org.apache.http.wire to see actual message):\n{}", new Object[]{uri, soapAction, message});
            }
            catch (IOException ex) {
                this.log.debug("IOException attempting to display soap response", (Throwable)ex);
            }
        }
        Object response = this.webServiceOperations.marshalSendAndReceive(uri, soapRequest, customCallback);
        if (this.log.isDebugEnabled()) {
            StringResult messageResponse = new StringResult();
            try {
                this.marshaller.marshal(response, (Result)messageResponse);
                this.log.debug("Soap response body (not exact, log org.apache.http.wire to see actual message):\n{}", (Object)messageResponse);
            }
            catch (IOException exception) {
                this.log.debug("IOException attempting to display soap response", (Throwable)exception);
            }
        }
        return response;
    }
}

